/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.result;

import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jdbi.v3.core.generic.GenericType;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.MappingException;
import org.jdbi.v3.core.mapper.NoSuchMapperException;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class RowView {
    private final StatementContext ctx;
    private final ResultSet rs;
    private final Map<Type, RowMapper<?>> rowMappers = new ConcurrentHashMap();
    private final Map<Type, ColumnMapper<?>> columnMappers = new ConcurrentHashMap();

    RowView(ResultSet rs, StatementContext ctx) {
        this.rs = rs;
        this.ctx = ctx;
    }

    public <T> T getRow(Class<T> rowType) {
        return rowType.cast(this.getRow((Type)rowType));
    }

    public <T> T getRow(GenericType<T> rowType) {
        return (T)this.getRow(rowType.getType());
    }

    public Object getRow(Type type) {
        try {
            return this.rowMapperFor(type).map(this.rs, this.ctx);
        }
        catch (SQLException e) {
            throw new MappingException(e);
        }
    }

    private RowMapper<?> rowMapperFor(Type type) throws SQLException {
        if (this.rowMappers.containsKey(type)) {
            return this.rowMappers.get(type);
        }
        RowMapper<?> mapper = this.ctx.findRowMapperFor(type).orElseThrow(() -> new NoSuchMapperException("No row mapper registered for " + type)).specialize(this.rs, this.ctx);
        this.rowMappers.put(type, mapper);
        return mapper;
    }

    public <T> T getColumn(String column, Class<T> type) {
        return type.cast(this.getColumn(column, (Type)type));
    }

    public <T> T getColumn(int column, Class<T> type) {
        return type.cast(this.getColumn(column, (Type)type));
    }

    public <T> T getColumn(String column, GenericType<T> type) {
        return (T)this.getColumn(column, type.getType());
    }

    public <T> T getColumn(int column, GenericType<T> type) {
        return (T)this.getColumn(column, type.getType());
    }

    public Object getColumn(String column, Type type) {
        try {
            return this.columnMapperFor(type).map(this.rs, column, this.ctx);
        }
        catch (SQLException e) {
            throw new MappingException(e);
        }
    }

    public Object getColumn(int column, Type type) {
        try {
            return this.columnMapperFor(type).map(this.rs, column, this.ctx);
        }
        catch (SQLException e) {
            throw new MappingException(e);
        }
    }

    private ColumnMapper<?> columnMapperFor(Type type) {
        return this.columnMappers.computeIfAbsent(type, t -> this.ctx.findColumnMapperFor((Type)t).orElseThrow(() -> new NoSuchMapperException("No column mapper registered for " + t)));
    }
}

