/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.mapper;

import java.lang.reflect.Type;
import java.util.Optional;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.ColumnMapperFactory;

class InferredColumnMapperFactory
implements ColumnMapperFactory {
    private final Type maps;
    private final ColumnMapper<?> mapper;

    InferredColumnMapperFactory(ColumnMapper<?> mapper) {
        this.maps = GenericTypes.findGenericParameter(mapper.getClass(), ColumnMapper.class).orElseThrow(() -> new UnsupportedOperationException("Must use a concretely typed ColumnMapper here"));
        this.mapper = mapper;
    }

    @Override
    public Optional<ColumnMapper<?>> build(Type type, ConfigRegistry config) {
        return this.maps.equals(type) ? Optional.of(this.mapper) : Optional.empty();
    }
}

