/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jdbi.v3.core.statement.ParsedParameters;
import org.jdbi.v3.core.statement.UnableToExecuteStatementException;

public class ParsedSql {
    private static final String POSITIONAL_PARAM = "?";
    private final String sql;
    private final ParsedParameters parameters;

    private ParsedSql(String sql, ParsedParameters parameters) {
        this.sql = sql;
        this.parameters = parameters;
    }

    public String getSql() {
        return this.sql;
    }

    public ParsedParameters getParameters() {
        return this.parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParsedSql that = (ParsedSql)o;
        return Objects.equals(this.sql, that.sql) && Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.sql, this.parameters);
    }

    public String toString() {
        return "ParsedSql{sql='" + this.sql + '\'' + ", parameters=" + this.parameters + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final StringBuilder sql = new StringBuilder();
        private boolean positional = false;
        private boolean named = false;
        private final List<String> parameterNames = new ArrayList<String>();

        private Builder() {
        }

        public Builder append(String sqlFragment) {
            this.sql.append(sqlFragment);
            return this;
        }

        public Builder appendPositionalParameter() {
            this.positional = true;
            this.parameterNames.add(ParsedSql.POSITIONAL_PARAM);
            return this.append(ParsedSql.POSITIONAL_PARAM);
        }

        public Builder appendNamedParameter(String name) {
            this.named = true;
            this.parameterNames.add(name);
            return this.append(ParsedSql.POSITIONAL_PARAM);
        }

        public ParsedSql build() {
            if (this.positional && this.named) {
                throw new UnableToExecuteStatementException("Cannot mix named and positional parameters in a SQL statement: " + this.parameterNames);
            }
            ParsedParameters parameters = new ParsedParameters(this.positional, this.parameterNames);
            return new ParsedSql(this.sql.toString(), parameters);
        }
    }
}

