/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.mapper.reflect;

import java.beans.ConstructorProperties;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdbi.v3.core.mapper.reflect.JdbiConstructor;

public class JdbiConstructors {
    public static <T> Constructor<T> findConstructorFor(Class<T> type) {
        Constructor<?>[] constructors = type.getDeclaredConstructors();
        List annotatedConstructors = Stream.of(constructors).filter(c -> c.isAnnotationPresent(JdbiConstructor.class)).collect(Collectors.toList());
        if (annotatedConstructors.size() > 1) {
            throw new IllegalArgumentException(type + " must have at most one constructor annotated @JdbiConstructor");
        }
        if (annotatedConstructors.size() == 1) {
            return (Constructor)annotatedConstructors.get(0);
        }
        annotatedConstructors = Stream.of(constructors).filter(c -> c.isAnnotationPresent(ConstructorProperties.class)).collect(Collectors.toList());
        if (annotatedConstructors.size() > 1) {
            throw new IllegalArgumentException(type + " must have at most one constructor annotated @ConstructorProperties");
        }
        if (annotatedConstructors.size() == 1) {
            return (Constructor)annotatedConstructors.get(0);
        }
        if (constructors.length != 1) {
            throw new IllegalArgumentException(type + " must have exactly one constructor, or specify it with @JdbiConstructor or @ConstructorProperties");
        }
        return constructors[0];
    }
}

