/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core;

import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import javax.sql.DataSource;
import org.jdbi.v3.core.ConnectionException;
import org.jdbi.v3.core.ConnectionFactory;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.HandleCallback;
import org.jdbi.v3.core.HandleConsumer;
import org.jdbi.v3.core.LazyHandleSupplier;
import org.jdbi.v3.core.OnDemandExtensions;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.config.Configurable;
import org.jdbi.v3.core.extension.ExtensionCallback;
import org.jdbi.v3.core.extension.ExtensionConsumer;
import org.jdbi.v3.core.extension.Extensions;
import org.jdbi.v3.core.extension.NoSuchExtensionException;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.DefaultStatementBuilder;
import org.jdbi.v3.core.statement.StatementBuilder;
import org.jdbi.v3.core.statement.StatementBuilderFactory;
import org.jdbi.v3.core.transaction.LocalTransactionHandler;
import org.jdbi.v3.core.transaction.TransactionHandler;
import org.jdbi.v3.core.transaction.TransactionIsolationLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jdbi
implements Configurable<Jdbi> {
    private static final Logger LOG = LoggerFactory.getLogger(Jdbi.class);
    private final ConfigRegistry config = new ConfigRegistry();
    private final ConnectionFactory connectionFactory;
    private final AtomicReference<TransactionHandler> transactionhandler = new AtomicReference<LocalTransactionHandler>(new LocalTransactionHandler());
    private final AtomicReference<StatementBuilderFactory> statementBuilderFactory = new AtomicReference<StatementBuilderFactory>(DefaultStatementBuilder.FACTORY);
    private final CopyOnWriteArrayList<JdbiPlugin> plugins = new CopyOnWriteArrayList();

    private Jdbi(ConnectionFactory connectionFactory) {
        Objects.requireNonNull(connectionFactory, "null connectionFactory");
        this.connectionFactory = connectionFactory;
    }

    public static Jdbi create(DataSource dataSource) {
        return Jdbi.create(dataSource::getConnection);
    }

    public static Jdbi create(ConnectionFactory connectionFactory) {
        return new Jdbi(connectionFactory);
    }

    public static Jdbi create(String url) {
        Objects.requireNonNull(url, "null url");
        return Jdbi.create(() -> DriverManager.getConnection(url));
    }

    public static Jdbi create(String url, Properties properties) {
        Objects.requireNonNull(url, "null url");
        Objects.requireNonNull(properties, "null properties");
        return Jdbi.create(() -> DriverManager.getConnection(url, properties));
    }

    public static Jdbi create(String url, String username, String password) {
        Objects.requireNonNull(url, "null url");
        Objects.requireNonNull(username, "null username");
        Objects.requireNonNull(password, "null password");
        return Jdbi.create(() -> DriverManager.getConnection(url, username, password));
    }

    public static Handle open(DataSource dataSource) {
        return Jdbi.create(dataSource).open();
    }

    public static Handle open(ConnectionFactory connectionFactory) {
        return Jdbi.create(connectionFactory).open();
    }

    public static Handle open(Connection connection) {
        Objects.requireNonNull(connection, "null connection");
        return Jdbi.create(() -> connection).open();
    }

    public static Handle open(String url) {
        return Jdbi.create(url).open();
    }

    public static Handle open(String url, String username, String password) {
        return Jdbi.create(url, username, password).open();
    }

    public static Handle open(String url, Properties props) {
        return Jdbi.create(url, props).open();
    }

    public Jdbi installPlugins() {
        ServiceLoader.load(JdbiPlugin.class).forEach(this::installPlugin);
        LOG.debug("Automatically installed plugins {}", this.plugins);
        return this;
    }

    public Jdbi installPlugin(JdbiPlugin plugin) {
        plugin.customizeJdbi(this);
        this.plugins.add(plugin);
        return this;
    }

    public Jdbi setStatementBuilderFactory(StatementBuilderFactory factory) {
        this.statementBuilderFactory.set(factory);
        return this;
    }

    public StatementBuilderFactory getStatementBuilderFactory() {
        return this.statementBuilderFactory.get();
    }

    @Override
    public ConfigRegistry getConfig() {
        return this.config;
    }

    public Jdbi setTransactionHandler(TransactionHandler handler) {
        Objects.requireNonNull(handler, "null transaction handler");
        this.transactionhandler.set(handler);
        return this;
    }

    public TransactionHandler getTransactionHandler() {
        return this.transactionhandler.get();
    }

    public Handle open() {
        try {
            long start = System.nanoTime();
            Connection conn = this.connectionFactory.openConnection();
            long stop = System.nanoTime();
            for (JdbiPlugin p : this.plugins) {
                conn = p.customizeConnection(conn);
            }
            StatementBuilder cache = this.statementBuilderFactory.get().createStatementBuilder(conn);
            Handle h = new Handle(this.config.createCopy(), this.transactionhandler.get(), cache, conn);
            for (JdbiPlugin p : this.plugins) {
                h = p.customizeHandle(h);
            }
            LOG.trace("Jdbi [{}] obtain handle [{}] in {}ms", new Object[]{this, h, (stop - start) / 1000000L});
            return h;
        }
        catch (SQLException e) {
            throw new ConnectionException(e);
        }
    }

    public <R, X extends Exception> R withHandle(HandleCallback<R, X> callback) throws X {
        try (Handle h = this.open();){
            R r = callback.withHandle(h);
            return r;
        }
    }

    public <X extends Exception> void useHandle(HandleConsumer<X> callback) throws X {
        this.withHandle(h -> {
            callback.useHandle(h);
            return null;
        });
    }

    public <R, X extends Exception> R inTransaction(HandleCallback<R, X> callback) throws X {
        return (R)this.withHandle(handle -> handle.inTransaction(callback));
    }

    public <X extends Exception> void useTransaction(HandleConsumer<X> callback) throws X {
        this.useHandle(handle -> handle.useTransaction(callback));
    }

    public <R, X extends Exception> R inTransaction(TransactionIsolationLevel level, HandleCallback<R, X> callback) throws X {
        return (R)this.withHandle(handle -> handle.inTransaction(level, callback));
    }

    public <X extends Exception> void useTransaction(TransactionIsolationLevel level, HandleConsumer<X> callback) throws X {
        this.useHandle(handle -> handle.useTransaction(level, callback));
    }

    public <R, E, X extends Exception> R withExtension(Class<E> extensionType, ExtensionCallback<R, E, X> callback) throws NoSuchExtensionException, X {
        try (LazyHandleSupplier handle = new LazyHandleSupplier(this, this.config);){
            E extension = this.getConfig(Extensions.class).findFor(extensionType, handle).orElseThrow(() -> new NoSuchExtensionException("Extension not found: " + extensionType));
            R r = callback.withExtension(extension);
            return r;
        }
    }

    public <E, X extends Exception> void useExtension(Class<E> extensionType, ExtensionConsumer<E, X> callback) throws NoSuchExtensionException, X {
        this.withExtension(extensionType, extension -> {
            callback.useExtension(extension);
            return null;
        });
    }

    public <E> E onDemand(Class<E> extensionType) throws NoSuchExtensionException {
        if (!extensionType.isInterface()) {
            throw new IllegalArgumentException("On-demand extensions are only supported for interfaces.");
        }
        if (!Modifier.isPublic(extensionType.getModifiers())) {
            throw new IllegalArgumentException("On-demand extensions types must be public.");
        }
        if (!this.getConfig(Extensions.class).hasExtensionFor(extensionType)) {
            throw new NoSuchExtensionException("Extension not found: " + extensionType);
        }
        return OnDemandExtensions.create(this, extensionType);
    }
}

