/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.config;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.jdbi.v3.core.config.JdbiConfig;

public class ConfigRegistry {
    private final Map<Class<? extends JdbiConfig<?>>, JdbiConfig<?>> cache = Collections.synchronizedMap(new WeakHashMap());

    public ConfigRegistry() {
    }

    private ConfigRegistry(ConfigRegistry that) {
        that.cache.forEach((type, config) -> {
            Object copy = config.createCopy();
            copy.setRegistry(this);
            this.cache.put((Class<JdbiConfig<?>>)type, (JdbiConfig<?>)copy);
        });
    }

    public <C extends JdbiConfig<C>> C get(Class<C> configClass) {
        return (C)((JdbiConfig)configClass.cast(this.cache.computeIfAbsent(configClass, type -> {
            try {
                JdbiConfig config = (JdbiConfig)configClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                config.setRegistry(this);
                return config;
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("Unable to instantiate config class " + configClass + ". Is there a public no-arg constructor?", e);
            }
        })));
    }

    public ConfigRegistry createCopy() {
        return new ConfigRegistry(this);
    }
}

