/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.argument;

import java.lang.reflect.Method;
import java.util.Optional;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.MethodReturnValueNamedArgumentFinder;
import org.jdbi.v3.core.statement.StatementContext;

public class ObjectMethodArguments
extends MethodReturnValueNamedArgumentFinder {
    public ObjectMethodArguments(String prefix, Object object) {
        super(prefix, object);
    }

    @Override
    Optional<Argument> find0(String name, StatementContext ctx) {
        if (name.startsWith(this.prefix)) {
            String propertyName = name.substring(this.prefix.length());
            for (Method method : this.object.getClass().getMethods()) {
                if (method.getParameterCount() != 0 || !method.getName().equals(propertyName)) continue;
                return this.getArgumentForMethod(method, ctx);
            }
        }
        return Optional.empty();
    }

    public String toString() {
        return "{lazy object functions arguments \"" + this.object + "\"";
    }
}

