/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.argument;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Optional;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.ObjectPropertyNamedArgumentFinder;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;

abstract class MethodReturnValueNamedArgumentFinder
extends ObjectPropertyNamedArgumentFinder {
    protected MethodReturnValueNamedArgumentFinder(String prefix, Object object) {
        super(prefix, object);
    }

    protected Optional<Argument> getArgumentForMethod(Method method, StatementContext ctx) {
        try {
            Type propertyType = method.getGenericReturnType();
            Object propertyValue = method.invoke(this.object, new Object[0]);
            Optional<Argument> argument = ctx.findArgumentFor(propertyType, propertyValue);
            if (!argument.isPresent()) {
                throw new UnableToCreateStatementException(String.format("No argument factory registered for type [%s] for method [%s] on [%s]", propertyType, method.getName(), this.object), ctx);
            }
            return argument;
        }
        catch (IllegalAccessException e) {
            throw new UnableToCreateStatementException(String.format("Access exception invoking method [%s] on [%s]", method.getName(), this.object), e, ctx);
        }
        catch (InvocationTargetException e) {
            throw new UnableToCreateStatementException(String.format("Invocation target exception invoking method [%s] on [%s]", method.getName(), this.object), e, ctx);
        }
    }
}

