/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.mapper;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jdbi.v3.core.array.SqlArrayMapperFactory;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.config.JdbiConfig;
import org.jdbi.v3.core.generic.GenericType;
import org.jdbi.v3.core.internal.JdbiStreams;
import org.jdbi.v3.core.mapper.BuiltInMapperFactory;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.ColumnMapperFactory;
import org.jdbi.v3.core.mapper.InferredColumnMapperFactory;

public class ColumnMappers
implements JdbiConfig<ColumnMappers> {
    private final List<ColumnMapperFactory> factories = new CopyOnWriteArrayList<ColumnMapperFactory>();
    private final ConcurrentHashMap<Type, ColumnMapper<?>> cache = new ConcurrentHashMap();
    private ConfigRegistry registry;

    public ColumnMappers() {
        this.factories.add(new BuiltInMapperFactory());
        this.factories.add(new SqlArrayMapperFactory());
    }

    @Override
    public void setRegistry(ConfigRegistry registry) {
        this.registry = registry;
    }

    private ColumnMappers(ColumnMappers that) {
        this.factories.addAll(that.factories);
        this.cache.putAll(that.cache);
    }

    public ColumnMappers register(ColumnMapper<?> mapper) {
        return this.register(new InferredColumnMapperFactory(mapper));
    }

    public ColumnMappers register(Type type, ColumnMapper<?> mapper) {
        return this.register(ColumnMapperFactory.of(type, mapper));
    }

    public ColumnMappers register(ColumnMapperFactory factory) {
        this.factories.add(0, factory);
        this.cache.clear();
        return this;
    }

    public <T> Optional<ColumnMapper<T>> findFor(Class<T> type) {
        ColumnMapper mapper = this.findFor((Type)type).orElse(null);
        return Optional.ofNullable(mapper);
    }

    public <T> Optional<ColumnMapper<T>> findFor(GenericType<T> type) {
        ColumnMapper mapper = this.findFor(type.getType()).orElse(null);
        return Optional.ofNullable(mapper);
    }

    public Optional<ColumnMapper<?>> findFor(Type type) {
        ColumnMapper<?> cached = this.cache.get(type);
        if (cached != null) {
            return Optional.of(cached);
        }
        Optional<ColumnMapper<?>> mapper = this.factories.stream().flatMap(factory -> JdbiStreams.toStream(factory.build(type, this.registry))).findFirst();
        mapper.ifPresent(m -> this.cache.put(type, (ColumnMapper<?>)m));
        return mapper;
    }

    @Override
    public ColumnMappers createCopy() {
        return new ColumnMappers(this);
    }
}

