/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.commonstext;

import java.util.function.Consumer;
import org.apache.commons.text.StringSubstitutor;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.TemplateEngine;

public class StringSubstitutorTemplateEngine
implements TemplateEngine {
    private final Consumer<StringSubstitutor> customizer;

    private StringSubstitutorTemplateEngine(Consumer<StringSubstitutor> customizer) {
        this.customizer = customizer;
    }

    public String render(String template, StatementContext ctx) {
        StringSubstitutor substitutor = new StringSubstitutor(ctx.getAttributes());
        this.customizer.accept(substitutor);
        return substitutor.replace(template);
    }

    public static StringSubstitutorTemplateEngine defaults() {
        return new StringSubstitutorTemplateEngine(substitutor -> {});
    }

    public static StringSubstitutorTemplateEngine withCustomizer(Consumer<StringSubstitutor> customizer) {
        return new StringSubstitutorTemplateEngine(customizer);
    }

    public static StringSubstitutorTemplateEngine between(char prefix, char suffix) {
        return new StringSubstitutorTemplateEngine(substitutor -> {
            substitutor.setVariablePrefix(prefix);
            substitutor.setVariableSuffix(suffix);
        });
    }

    public static StringSubstitutorTemplateEngine between(String prefix, String suffix) {
        return new StringSubstitutorTemplateEngine(substitutor -> {
            substitutor.setVariablePrefix(prefix);
            substitutor.setVariableSuffix(suffix);
        });
    }

    public static StringSubstitutorTemplateEngine between(char prefix, char suffix, char escape) {
        return new StringSubstitutorTemplateEngine(substitutor -> {
            substitutor.setVariablePrefix(prefix);
            substitutor.setVariableSuffix(suffix);
            substitutor.setEscapeChar(escape);
        });
    }

    public static StringSubstitutorTemplateEngine between(String prefix, String suffix, char escape) {
        return new StringSubstitutorTemplateEngine(substitutor -> {
            substitutor.setVariablePrefix(prefix);
            substitutor.setVariableSuffix(suffix);
            substitutor.setEscapeChar(escape);
        });
    }
}

