/*
 * Decompiled with CFR 0.152.
 */
package org.jdbcdslog;

import java.lang.reflect.Method;
import java.util.Map;
import org.jdbcdslog.ConfigurationParameters;
import org.jdbcdslog.LogMetaData;
import org.jdbcdslog.LogUtils;
import org.jdbcdslog.Loggers;
import org.jdbcdslog.LoggingHandlerSupport;
import org.jdbcdslog.ProxyUtils;
import org.slf4j.Logger;

public abstract class StatementLoggingHandlerTemplate
extends LoggingHandlerSupport {
    protected LogMetaData logMetaData;

    public StatementLoggingHandlerTemplate(Object target) {
        super(target);
    }

    public StatementLoggingHandlerTemplate(LogMetaData logMetaData, Object target) {
        super(target);
        this.logMetaData = logMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Map<String, String> oldMdc = LogUtils.setMdc(this.logMetaData);
        try {
            boolean needsLog = this.needsLogging(proxy, method, args);
            long startTimeInNano = 0L;
            StringBuilder sb = null;
            if (this.isAddBatch(proxy, method, args)) {
                if (!ConfigurationParameters.logAddBatchDetail) {
                    needsLog = false;
                }
                if (ConfigurationParameters.logExecuteBatchDetail) {
                    this.doAddBatch(proxy, method, args);
                }
            }
            if (needsLog) {
                startTimeInNano = System.nanoTime();
                sb = new StringBuilder();
                if (ConfigurationParameters.logBeforeStatement) {
                    sb.append("START: ");
                }
                sb.append(method.getDeclaringClass().getName()).append(".").append(method.getName()).append(": ");
                if (this.isExecuteBatch(proxy, method, args)) {
                    if (ConfigurationParameters.logExecuteBatchDetail) {
                        this.appendBatchStatements(sb);
                    }
                } else {
                    this.appendStatement(sb, proxy, method, args);
                }
                LogUtils.appendStackTrace(sb);
                this.logBeforeInvoke(proxy, method, args, sb);
            }
            Object result = method.invoke(this.target, args);
            result = this.doAfterInvoke(proxy, method, args, result);
            if (needsLog) {
                long elapsedTimeInNano = System.nanoTime() - startTimeInNano;
                if (ConfigurationParameters.logBeforeStatement) {
                    sb.setCharAt(0, 'E');
                    sb.setCharAt(1, 'N');
                    sb.setCharAt(2, 'D');
                    sb.setCharAt(3, ':');
                    sb.setCharAt(4, ' ');
                    sb.setCharAt(5, ' ');
                    sb.setCharAt(6, ' ');
                }
                LogUtils.appendElapsedTime(sb, elapsedTimeInNano);
                this.logAfterInvoke(proxy, method, args, result, elapsedTimeInNano, sb);
            }
            Object object = result;
            return object;
        }
        catch (Throwable t) {
            this.handleException(t, proxy, method, args);
        }
        finally {
            LogUtils.resetMdc(oldMdc);
        }
        return null;
    }

    protected abstract void doAddBatch(Object var1, Method var2, Object[] var3);

    protected abstract void appendBatchStatements(StringBuilder var1);

    protected boolean isExecuteBatch(Object proxy, Method method, Object[] args) {
        return method.getName().equals("executeBatch");
    }

    protected boolean isAddBatch(Object proxy, Method method, Object[] args) {
        return method.getName().equals("addBatch");
    }

    protected abstract void appendStatement(StringBuilder var1, Object var2, Method var3, Object[] var4);

    protected boolean needsLogging(Object proxy, Method method, Object[] args) {
        return false;
    }

    protected void logBeforeInvoke(Object proxy, Method method, Object[] args, StringBuilder sb) {
        if (ConfigurationParameters.logBeforeStatement) {
            this.getLogger().info(sb.toString());
        }
    }

    protected Object doAfterInvoke(Object proxy, Method method, Object[] args, Object result) {
        return ProxyUtils.wrap(this.logMetaData, result, new Object[0]);
    }

    protected void logAfterInvoke(Object proxy, Method method, Object[] args, Object result, long elapsedTimeInNano, StringBuilder message) {
        StringBuilder endMessage = message;
        if (!ConfigurationParameters.logDetailAfterStatement) {
            endMessage = new StringBuilder("END:    ").append(method.getDeclaringClass().getName()).append(".").append(method.getName()).append(": ");
            LogUtils.appendStackTrace(endMessage);
            LogUtils.appendElapsedTime(endMessage, elapsedTimeInNano);
        }
        this.getLogger().info(endMessage.toString());
        if (elapsedTimeInNano >= ConfigurationParameters.slowQueryThresholdInNano) {
            this.getSlowQueryLogger().info(message.toString());
        }
    }

    protected boolean needsSlowOperationLogging(Object proxy, Method method, Object[] args, Object result, long elapsedTimeInNano) {
        return true;
    }

    protected void handleException(Throwable t, Object proxy, Method method, Object[] args) throws Throwable {
        LogUtils.handleException(t, this.getLogger(), LogUtils.createLogEntry(method, null, null, null));
    }

    protected Logger getLogger() {
        return Loggers.statementLogger;
    }

    protected Logger getSlowQueryLogger() {
        return Loggers.slowQueryLogger;
    }
}

