/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.xml;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.jdal.xml.ValidationResult;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public abstract class XMLUtils {
    private static Log log = LogFactory.getLog(XMLUtils.class);
    private static ThreadLocal<DocumentBuilder> dbLocal = new ThreadLocal();

    public static Document newDocumentFromResource(String res) {
        URL url = XMLUtils.class.getResource(res);
        return url != null ? XMLUtils.newDocumentFromFile(url.getFile()) : null;
    }

    public static Document newDocumentFromFile(String path) {
        Document doc = null;
        try {
            doc = XMLUtils.getDocumentBuilder().parse(new File(path));
        }
        catch (SAXException e) {
            log.error((Object)e);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        return doc;
    }

    public static Document newDocument(String xml) {
        Document doc = null;
        DocumentBuilder db = XMLUtils.getDocumentBuilder();
        try {
            doc = db.parse(new ByteArrayInputStream(xml.getBytes("UTF8")));
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return doc;
    }

    public static Document newDocument() {
        return XMLUtils.getDocumentBuilder().newDocument();
    }

    public static DocumentBuilder getDocumentBuilder() {
        DocumentBuilder db = dbLocal.get();
        if (db == null) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            try {
                db = dbf.newDocumentBuilder();
                dbLocal.set(db);
            }
            catch (ParserConfigurationException e) {
                log.error((Object)e);
            }
        }
        return db;
    }

    public static String prettyDocumentToString(Document doc) {
        StringWriter writer = new StringWriter();
        OutputFormat out = new OutputFormat();
        out.setOmitXMLDeclaration(true);
        out.setIndenting(true);
        out.setIndent(4);
        out.setLineSeparator(System.getProperty("line.separator"));
        out.setLineWidth(Integer.MAX_VALUE);
        XMLSerializer serializer = new XMLSerializer((Writer)writer, out);
        try {
            Element rootElement = doc.getDocumentElement();
            serializer.serialize(rootElement);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        return writer.toString();
    }

    public static String documentToString(Document doc) {
        return XMLUtils.elementToString(doc.getDocumentElement());
    }

    public static String elementToString(Element elto) {
        StringWriter writer = new StringWriter();
        OutputFormat of = new OutputFormat();
        of.setOmitXMLDeclaration(true);
        XMLSerializer serializer = new XMLSerializer((Writer)writer, of);
        serializer.setNamespaces(true);
        try {
            serializer.serialize(elto);
        }
        catch (IOException ioe) {
            log.error((Object)ioe);
        }
        return writer.toString();
    }

    public static Element stringToElement(String xml) {
        Document doc = XMLUtils.newDocument(xml);
        Element elto = doc.getDocumentElement();
        return (Element)elto.cloneNode(true);
    }

    public static synchronized Node copyNode(Node source, Node dest) {
        if (source.getNodeType() == 3) {
            Text tn = dest.getOwnerDocument().createTextNode(source.getNodeValue());
            return tn;
        }
        Node attr = null;
        NamedNodeMap attrs = source.getAttributes();
        if (attrs != null) {
            int i = 0;
            while (i < attrs.getLength()) {
                attr = attrs.item(i);
                ((Element)dest).setAttribute(attr.getNodeName(), attr.getNodeValue());
                ++i;
            }
        }
        Node child = null;
        NodeList list = source.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            child = list.item(i);
            if (!(child instanceof Text)) {
                Element en = dest.getOwnerDocument().createElementNS(child.getNamespaceURI(), child.getNodeName());
                if (child.getNodeValue() != null) {
                    en.setNodeValue(child.getNodeValue());
                }
                Node n = XMLUtils.copyNode(child, en);
                dest.appendChild(n);
            } else if (child instanceof CDATASection) {
                CDATASection cd = dest.getOwnerDocument().createCDATASection(child.getNodeValue());
                dest.appendChild(cd);
            } else {
                Text tn = dest.getOwnerDocument().createTextNode(child.getNodeValue());
                dest.appendChild(tn);
            }
            ++i;
        }
        return dest;
    }

    public static Document newDocument(String ns, String name) {
        return XMLUtils.getDocumentBuilder().getDOMImplementation().createDocument(ns, name, null);
    }

    public static ValidationResult validateSchema(String xml, Schema schema) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            StreamSource xmlSource = new StreamSource(bais);
            schema.newValidator().validate(xmlSource);
        }
        catch (Exception e) {
            log.warn((Object)e);
            return new ValidationResult(false, e.getMessage());
        }
        return new ValidationResult(true);
    }

    public static ValidationResult validateSchema(Document doc, Schema schema) {
        try {
            DOMSource xmlSource = new DOMSource(doc);
            schema.newValidator().validate(xmlSource);
        }
        catch (Exception e) {
            log.warn((Object)e);
            return new ValidationResult(false, e.getMessage());
        }
        return new ValidationResult(true);
    }
}

