/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.ui.bind;

import java.text.ParseException;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdal.text.FormatUtils;
import org.jdal.ui.bind.AbstractBinder;
import org.jdal.ui.bind.ControlAccessor;
import org.jdal.ui.bind.ControlAccessorFactory;
import org.springframework.format.Parser;
import org.springframework.format.Printer;

public class ControlBinder
extends AbstractBinder {
    private static final Log log = LogFactory.getLog(ControlBinder.class);
    private ControlAccessorFactory controlAccessorFactory;
    private ControlAccessor controlAccessor;

    public ControlBinder(ControlAccessorFactory controlAccessorFactory) {
        this.controlAccessorFactory = controlAccessorFactory;
    }

    @Override
    public void doBind() {
        this.controlAccessor = this.controlAccessorFactory.getControlAccessor(this.component);
    }

    @Override
    protected void doRefresh() {
        Printer<Object> printer;
        Object value = this.getValue();
        if (value != null && this.controlAccessor.isTextControl() && (printer = this.getPrinter()) != null) {
            value = printer.print(value, Locale.getDefault());
        }
        this.controlAccessor.setControlValue(value);
    }

    @Override
    protected void doUpdate() {
        Parser<?> parser;
        Object value = this.controlAccessor.getControlValue();
        if (this.controlAccessor.isTextControl() && (parser = this.getParser()) != null) {
            try {
                value = parser.parse((String)value, Locale.getDefault());
            }
            catch (ParseException e) {
                log.error((Object)("Can't parse String : " + value.toString()));
            }
        }
        this.setValue(value);
    }

    protected Printer<Object> getPrinter() {
        return FormatUtils.getPrinter(this.getModel().getClass(), this.propertyName);
    }

    protected Parser<?> getParser() {
        return FormatUtils.getParser(this.getModel().getClass(), this.propertyName);
    }

    public ControlAccessorFactory getControlAccessorFactory() {
        return this.controlAccessorFactory;
    }

    public void setControlAccessorFactory(ControlAccessorFactory controlAccessorFactory) {
        this.controlAccessorFactory = controlAccessorFactory;
    }
}

