/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.ui.bind;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdal.annotation.SerializableProxy;
import org.jdal.ui.View;
import org.jdal.ui.bind.ControlAccessor;
import org.jdal.ui.bind.ControlAccessorFactory;
import org.jdal.ui.bind.ViewAccessor;

@SerializableProxy
public class ConfigurableControlAccessorFactory
implements ControlAccessorFactory,
Serializable {
    private static final Log log = LogFactory.getLog(ConfigurableControlAccessorFactory.class);
    private static ConfigurableControlAccessorFactory defaultFactory;
    private Map<Class<?>, Class<? extends ControlAccessor>> accessors = new Hashtable();
    private boolean mergeAccessors = true;

    @Override
    public ControlAccessor getControlAccessor(Object control) {
        Class<? extends ControlAccessor> accessorClass = null;
        ControlAccessor accessor = null;
        Class<?> clazz = control.getClass();
        accessorClass = this.accessors.get(clazz);
        if (accessorClass == null) {
            List superclasses = ClassUtils.getAllSuperclasses(clazz);
            superclasses.addAll(ClassUtils.getAllInterfaces(clazz));
            Iterator iter = superclasses.iterator();
            while (iter.hasNext() && accessorClass == null) {
                accessorClass = this.accessors.get(iter.next());
            }
        }
        if (accessorClass != null) {
            try {
                Constructor<? extends ControlAccessor> ctor = accessorClass.getConstructor(Object.class);
                accessor = ctor.newInstance(control);
            }
            catch (InstantiationException e) {
                log.error((Object)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)e);
            }
            catch (SecurityException e) {
                log.error((Object)e);
            }
            catch (NoSuchMethodException e) {
                log.error((Object)e);
            }
            catch (IllegalArgumentException e) {
                log.error((Object)e);
            }
            catch (InvocationTargetException e) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(baos));
                log.error((Object)baos);
            }
        } else {
            log.warn((Object)("Can't find a accessor for class: " + clazz.getName()));
        }
        return accessor;
    }

    public static synchronized ConfigurableControlAccessorFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = new ConfigurableControlAccessorFactory();
        }
        ConfigurableControlAccessorFactory.configureDefaultAccessors(defaultFactory);
        return defaultFactory;
    }

    private static void configureDefaultAccessors(ConfigurableControlAccessorFactory factory) {
        Map<Class<?>, Class<ControlAccessor>> accessors = factory.getAccessors();
        accessors.put(View.class, ViewAccessor.class);
    }

    public Map<Class<?>, Class<? extends ControlAccessor>> getAccessors() {
        return this.accessors;
    }

    public void setAccessors(Map<Class<?>, Class<? extends ControlAccessor>> accessors) {
        if (!this.mergeAccessors) {
            this.accessors.clear();
        }
        this.accessors.putAll(accessors);
    }

    public boolean isMergeAccessors() {
        return this.mergeAccessors;
    }

    public void setMergeAccessors(boolean mergeAccessors) {
        this.mergeAccessors = mergeAccessors;
    }
}

