/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.text;

import java.text.ParseException;
import java.util.Locale;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import org.springframework.format.Formatter;

public class PeriodFormatter
implements Formatter<Number> {
    private static final String DAYS = "d";
    private static final String HOURS = "h";
    private static final String MINUTES = "m";
    private static final String SECONDS = "s";

    public String print(Number number, Locale locale) {
        long period = number.longValue();
        long days = TimeUnit.MILLISECONDS.toDays(period);
        long left = period - TimeUnit.DAYS.toMillis(days);
        long hours = TimeUnit.MILLISECONDS.toHours(left);
        long minutes = TimeUnit.MILLISECONDS.toMinutes(left -= TimeUnit.HOURS.toMillis(hours));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(left -= TimeUnit.MINUTES.toMillis(minutes));
        StringBuilder sb = new StringBuilder();
        if (days != 0L) {
            this.append(sb, days, DAYS);
        }
        if (hours != 0L) {
            this.append(sb, hours, HOURS);
        }
        if (minutes != 0L) {
            this.append(sb, minutes, MINUTES);
        }
        if (seconds != 0L) {
            this.append(sb, seconds, SECONDS);
        }
        return sb.toString();
    }

    private void append(StringBuilder sb, long period, String unit) {
        if (sb.length() > 0) {
            sb.append(" ");
        }
        sb.append(period);
        sb.append(" ");
        sb.append(unit);
    }

    public Number parse(String text, Locale locale) throws ParseException {
        long value = 0L;
        Scanner scanner = new Scanner(text);
        while (scanner.hasNext()) {
            value += this.parse(scanner.nextLong(), scanner.next("[dhms]"));
        }
        scanner.close();
        return value;
    }

    private long parse(long value, String unit) {
        if (DAYS.equalsIgnoreCase(unit)) {
            return TimeUnit.DAYS.toMillis(value);
        }
        if (HOURS.equalsIgnoreCase(unit)) {
            return TimeUnit.HOURS.toMillis(value);
        }
        if (MINUTES.equalsIgnoreCase(unit)) {
            return TimeUnit.MINUTES.toMillis(value);
        }
        if (SECONDS.equalsIgnoreCase(unit)) {
            return TimeUnit.SECONDS.toMillis(value);
        }
        return 0L;
    }
}

