/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.reporting.datasource;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.data.JRAbstractBeanDataSource;
import org.jdal.dao.Page;
import org.jdal.dao.PageableDataSource;

public class PageJRDatasourceAdapter
extends JRAbstractBeanDataSource {
    private Page<Object> page;
    private Object currentObject;
    private int index = 0;

    public PageJRDatasourceAdapter(PageableDataSource<Object> ds) {
        this(true);
        this.page = new Page();
        this.page.setPageableDataSource(ds);
    }

    public PageJRDatasourceAdapter(boolean isUseFieldDescription) {
        super(isUseFieldDescription);
    }

    public void moveFirst() throws JRException {
        this.page.firstPage();
    }

    public Object getFieldValue(JRField field) throws JRException {
        try {
            return PageJRDatasourceAdapter.getBeanProperty((Object)this.currentObject, (String)field.getName());
        }
        catch (Exception e) {
            throw new JRException((Throwable)e);
        }
    }

    public boolean next() throws JRException {
        if (this.getCurrentObject()) {
            return true;
        }
        if (this.page.hasNext()) {
            this.page.nextPage();
            this.index = 0;
            return this.getCurrentObject();
        }
        return false;
    }

    private boolean getCurrentObject() {
        if (this.index < this.page.getData().size()) {
            this.currentObject = this.page.getData().get(this.index++);
            return true;
        }
        return false;
    }

    public Page<Object> getPage() {
        return this.page;
    }

    public void setPage(Page<Object> page) {
        this.page = page;
        if (page.getData() == null || page.getData().size() == 0) {
            page.load();
        }
    }
}

