/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.remoting.rmi;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang.StringUtils;
import org.springframework.remoting.rmi.RmiClientInterceptorUtils;
import org.springframework.remoting.rmi.RmiInvocationHandler;
import org.springframework.remoting.support.RemoteInvocationBasedAccessor;

public class RmiServiceInterceptor
extends RemoteInvocationBasedAccessor
implements MethodInterceptor,
Serializable {
    private RmiInvocationHandler invocationHandler;
    private String serviceName;

    public RmiServiceInterceptor(RmiInvocationHandler invocationHandler) {
        this(invocationHandler, null);
    }

    public RmiServiceInterceptor(RmiInvocationHandler invocationHandler, String serviceName) {
        this.invocationHandler = invocationHandler;
        this.serviceName = serviceName;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        try {
            return this.invocationHandler.invoke(this.createRemoteInvocation(invocation));
        }
        catch (RemoteException ex) {
            throw RmiClientInterceptorUtils.convertRmiAccessException((Method)invocation.getMethod(), (RemoteException)ex, (boolean)RmiClientInterceptorUtils.isConnectFailure((RemoteException)ex), (String)this.extractServiceUrl());
        }
    }

    private String extractServiceUrl() {
        String toParse = this.invocationHandler.toString();
        String url = "rmi://" + StringUtils.substringBefore((String)StringUtils.substringAfter((String)toParse, (String)"endpoint:["), (String)"]");
        if (this.serviceName != null) {
            url = String.valueOf(StringUtils.substringBefore((String)url, (String)":")) + "/" + this.serviceName;
        }
        return url;
    }
}

