/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.remoting.rmi;

import org.aopalliance.aop.Advice;
import org.jdal.remoting.ReferenceRemoteInvocationFactory;
import org.jdal.remoting.RemoteClient;
import org.jdal.remoting.RemoteClientAdvisor;
import org.jdal.remoting.RemoteReference;
import org.jdal.remoting.rmi.RmiNativeRemoteReference;
import org.jdal.remoting.rmi.RmiRemoteReference;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.remoting.rmi.RmiClientInterceptor;
import org.springframework.remoting.support.UrlBasedRemoteAccessor;

public class RmiProxyFactoryBean
extends RmiClientInterceptor
implements FactoryBean<Object>,
BeanClassLoaderAware {
    private Object serviceProxy;
    private boolean useNativeReferences = true;

    public RmiProxyFactoryBean() {
        this.setRemoteInvocationFactory(new ReferenceRemoteInvocationFactory());
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (this.getServiceInterface() == null) {
            throw new IllegalArgumentException("Property 'serviceInterface' is required");
        }
        ProxyFactory pf = new ProxyFactory(new Class[]{this.getServiceInterface(), RemoteClient.class});
        pf.addAdvisor((Advisor)new RemoteClientAdvisor(this.getRemoteReference()));
        pf.addAdvice((Advice)this);
        this.serviceProxy = pf.getProxy();
    }

    public Object getObject() throws Exception {
        return this.serviceProxy;
    }

    public Class<?> getObjectType() {
        return this.getServiceInterface();
    }

    public boolean isSingleton() {
        return true;
    }

    private RemoteReference getRemoteReference() {
        if (this.isUseNativeReferences()) {
            return new RmiNativeRemoteReference(this.getStub(), this.getServiceInterface());
        }
        return new RmiRemoteReference((UrlBasedRemoteAccessor)this);
    }

    public boolean isUseNativeReferences() {
        return this.useNativeReferences;
    }

    public void setUseNativeReferences(boolean useNativeReferences) {
        this.useNativeReferences = useNativeReferences;
    }
}

