/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.logic;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jdal.dao.Dao;
import org.jdal.dao.Page;
import org.jdal.util.BeanUtils;
import org.jdal.util.comparator.PropertyComparator;

public class CollectionPersistenceService<T, PK extends Serializable>
implements Dao<T, PK> {
    private Collection<T> collection;
    private String propertyKey = "id";

    public CollectionPersistenceService() {
        this.collection = new ArrayList<T>();
    }

    public CollectionPersistenceService(Collection<T> collection) {
        this.collection = collection;
    }

    @Override
    public <K> Page<K> getPage(Page<K> page) {
        if (this.collection.isEmpty()) {
            page.setCount(0);
            page.setData(new ArrayList());
            return page;
        }
        ArrayList<T> list = new ArrayList<T>(this.collection);
        int startIndex = page.getStartIndex() < list.size() ? page.getStartIndex() : list.size() - 1;
        int toIndex = page.getStartIndex() + page.getPageSize();
        int n = toIndex = toIndex < list.size() ? toIndex : list.size();
        if (!StringUtils.isEmpty((String)page.getSortName())) {
            Collections.sort(list, new PropertyComparator(page.getSortName()));
            if (page.getOrder() == Page.Order.DESC) {
                Collections.reverse(list);
            }
        }
        page.setData(list.subList(startIndex, toIndex));
        page.setCount(list.size());
        return page;
    }

    @Override
    public List<Serializable> getKeys(Page<T> page) {
        ArrayList<Serializable> keys = new ArrayList<Serializable>();
        Object keyPage = page.clone();
        this.getPage((Page)keyPage);
        for (Object model : ((Page)keyPage).getData()) {
            Object value = BeanUtils.getProperty(model, this.propertyKey);
            if (value == null) continue;
            keys.add((Serializable)value);
        }
        return keys;
    }

    @Override
    public T initialize(T entity, int depth) {
        return entity;
    }

    @Override
    public T initialize(T entity) {
        return entity;
    }

    @Override
    public T save(T entity) {
        if (this.collection.contains(entity)) {
            this.collection.remove(entity);
        }
        this.collection.add(entity);
        return entity;
    }

    @Override
    public void delete(T entity) {
        this.collection.remove(entity);
    }

    @Override
    public void deleteById(PK id) {
        this.collection.remove(this.get(id));
    }

    @Override
    public List<T> getAll() {
        return new ArrayList<T>(this.collection);
    }

    @Override
    public Collection<T> save(Collection<T> collection) {
        for (T model : collection) {
            this.save(model);
        }
        return collection;
    }

    @Override
    public void delete(Collection<T> collection) {
        for (T model : collection) {
            this.delete(model);
        }
    }

    @Override
    public void deleteById(Collection<PK> ids) {
        for (Serializable id : ids) {
            this.deleteById(id);
        }
    }

    @Override
    public T get(PK id) {
        for (T model : this.collection) {
            Object value = BeanUtils.getProperty(model, this.propertyKey);
            if (value == null || !value.equals(id)) continue;
            return model;
        }
        return null;
    }

    @Override
    public <E> E get(PK id, Class<E> clazz) {
        return (E)this.get(id);
    }

    @Override
    public <E> List<E> getAll(Class<E> clazz) {
        return this.getAll();
    }

    @Override
    public Class<T> getEntityClass() {
        return this.collection.isEmpty() ? null : this.collection.iterator().next().getClass();
    }

    public Collection<T> getCollection() {
        return this.collection;
    }

    public void setCollection(Collection<T> collection) {
        this.collection = collection;
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }

    public void setPropertyKey(String propertyKey) {
        this.propertyKey = propertyKey;
    }

    @Override
    public boolean exists(PK id) {
        return this.get(id) != null;
    }

    @Override
    public List<T> findByNamedQuery(String queryName, Map<String, Object> queryParams) {
        throw new UnsupportedOperationException();
    }
}

