/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.dao.jpa.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.metamodel.EntityType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdal.dao.jpa.query.QueryFinderSupport;

public class EntityTypeQueryFinder
extends QueryFinderSupport {
    private static final Log log = LogFactory.getLog(EntityTypeQueryFinder.class);
    private EntityType<?> entityType;

    public EntityTypeQueryFinder(EntityType<?> entityType) {
        this.entityType = entityType;
    }

    @Override
    public Map<String, String> find() {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        ArrayList<NamedQuery> namedQueries = new ArrayList<NamedQuery>();
        NamedQueries nqs = this.entityType.getJavaType().getAnnotation(NamedQueries.class);
        if (nqs != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found NamedQueries in type: " + this.entityType.getName()));
            }
            namedQueries.addAll(Arrays.asList(nqs.value()));
        } else {
            NamedQuery nq = this.entityType.getJavaType().getAnnotation(NamedQuery.class);
            if (nq != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found NamedQueries in type: " + this.entityType.getName()));
                }
                namedQueries.add(nq);
            }
        }
        for (NamedQuery nq : namedQueries) {
            queryMap.put(nq.name(), nq.query());
        }
        return queryMap;
    }
}

