/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.dao.jpa;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Parameter;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdal.dao.DaoSupport;
import org.jdal.dao.Filter;
import org.jdal.dao.Page;
import org.jdal.dao.jpa.JpaCriteriaBuilder;
import org.jdal.dao.jpa.JpaUtils;
import org.jdal.dao.jpa.query.EntityTypeQueryFinder;
import org.jdal.dao.jpa.query.QueryFinder;
import org.springframework.beans.ConfigurablePropertyAccessor;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.dao.InvalidDataAccessApiUsageException;

public class JpaDao<T, PK extends Serializable>
extends DaoSupport<T, PK> {
    private static final int DEFAULT_DEPTH = 2;
    private static final Log log = LogFactory.getLog(JpaDao.class);
    @PersistenceContext
    private EntityManager em;
    private Class<T> entityClass;
    private Map<String, JpaCriteriaBuilder<?>> criteriaBuilderMap = Collections.synchronizedMap(new HashMap());
    private QueryFinder queryFinder;
    private boolean onDeleteSetNull = true;

    public JpaDao() {
    }

    public JpaDao(Class<T> entityClass) {
        this.entityClass = entityClass;
    }

    @Override
    public <K> Page<K> getPage(Page<K> page) {
        TypedQuery<K> query = this.getNamedQuery(page);
        if (query == null) {
            query = this.getCriteriaQuery(page);
        }
        query.setMaxResults(page.getPageSize());
        query.setFirstResult(page.getStartIndex());
        page.setData(query.getResultList());
        page.setPageableDataSource(this);
        return page;
    }

    private <K> CriteriaQuery<K> getCriteria(Page<K> page) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery<?> c = cb.createQuery();
        Filter filter = null;
        if (page.getFilter() instanceof Filter) {
            filter = (Filter)page.getFilter();
            JpaCriteriaBuilder<?> jcb = this.criteriaBuilderMap.get(filter.getFilterName());
            if (jcb != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found JpaCriteriaBuilder for filter: " + filter.getFilterName()));
                }
                c = jcb.build(c, cb, filter);
            } else {
                log.error((Object)("No CriteriaBuilder found for filter name [" + filter.getFilterName() + "]"));
                c.from(this.entityClass);
            }
        } else {
            c.select((Selection)c.from(this.getEntityClass()));
        }
        return c;
    }

    private <K> TypedQuery<K> getCriteriaQuery(Page<K> page) {
        CriteriaQuery<K> criteria = this.getCriteria(page);
        CriteriaQuery<K> countCriteria = this.getCriteria(page);
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        Root root = (Root)countCriteria.getRoots().iterator().next();
        countCriteria.select((Selection)cb.count((Expression)root));
        page.setCount(((Long)this.em.createQuery(countCriteria).getSingleResult()).intValue());
        criteria.orderBy(new Order[]{this.getOrder(page, criteria)});
        if (criteria.getSelection() == null) {
            criteria.select((Selection)root);
        }
        return this.em.createQuery(criteria);
    }

    @Override
    public List<Serializable> getKeys(Page<T> page) {
        Filter filter = null;
        TypedQuery query = null;
        SingularAttribute<T, ?> id = this.getIdAttribute();
        if (page.getFilter() instanceof Filter) {
            filter = (Filter)page.getFilter();
            String queryString = this.getQueryString(filter.getFilterName());
            if (queryString != null) {
                String keyQuery = JpaUtils.getKeyQuery(queryString, id.getName());
                if (page.getSortName() != null) {
                    keyQuery = JpaUtils.addOrder(keyQuery, page.getSortName(), page.getOrder() == Page.Order.ASC);
                }
                query = this.em.createQuery(keyQuery, Serializable.class);
                this.applyFilter((Query)query, filter);
            } else {
                query = this.getKeyCriteriaQuery(id, page);
            }
        } else {
            query = this.getKeyCriteriaQuery(id, page);
        }
        query.setFirstResult(page.getStartIndex());
        query.setMaxResults(page.getPageSize());
        return query.getResultList();
    }

    private TypedQuery<Serializable> getKeyCriteriaQuery(SingularAttribute<? super T, ?> id, Page<T> page) {
        CriteriaQuery<T> keyCriteria = this.getCriteria(page);
        Root<T> keyRoot = JpaUtils.findRoot(keyCriteria, this.getEntityClass());
        keyCriteria.select((Selection)keyRoot.get(id.getName()));
        return this.em.createQuery(keyCriteria);
    }

    private SingularAttribute<? super T, ?> getIdAttribute() {
        return this.getIdAttribute(this.getEntityClass());
    }

    private <K> SingularAttribute<? super K, ?> getIdAttribute(Class<K> clazz) {
        Type type = this.em.getMetamodel().entity(clazz).getIdType();
        EntityType entity = this.em.getMetamodel().entity(clazz);
        SingularAttribute id = entity.getId(type.getJavaType());
        return id;
    }

    private Order getOrder(Page<?> page, CriteriaQuery<?> criteria) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        Root<T> root = JpaUtils.findRoot(criteria, this.getEntityClass());
        String propertyPath = page.getSortName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting order as: " + propertyPath));
        }
        Path path = JpaUtils.getPath(root, propertyPath);
        return page.getOrder() == Page.Order.ASC ? cb.asc(path) : cb.desc(path);
    }

    protected <K> TypedQuery<K> getNamedQuery(Page<K> page) {
        String queryString;
        Filter filter = null;
        TypedQuery query = null;
        if (page.getFilter() instanceof Filter && (queryString = this.getQueryString((filter = (Filter)page.getFilter()).getFilterName())) != null) {
            String countQueryString = JpaUtils.createCountQueryString(queryString);
            TypedQuery countQuery = this.em.createQuery(countQueryString, Long.class);
            this.applyFilter((Query)countQuery, filter);
            page.setCount(((Long)countQuery.getSingleResult()).intValue());
            if (page.getSortName() != null) {
                queryString = JpaUtils.addOrder(queryString, page.getSortName(), page.getOrder() == Page.Order.ASC);
            }
            query = (TypedQuery)this.em.createQuery(queryString);
            this.applyFilter((Query)query, filter);
        }
        return query;
    }

    private void applyFilter(Query query, Filter filter) {
        Map<String, Object> parameterMap = filter.getParameterMap();
        for (Parameter p : query.getParameters()) {
            if (parameterMap.containsKey(p.getName())) {
                query.setParameter(p.getName(), parameterMap.get(p.getName()));
                continue;
            }
            throw new InvalidDataAccessApiUsageException("Parameter " + p.getName() + "was not found in filter " + filter.getFilterName() + ". Review NamedQuery or Filter.");
        }
    }

    protected String getQueryString(String name) {
        if (this.queryFinder == null) {
            this.queryFinder = new EntityTypeQueryFinder(this.em.getMetamodel().entity(this.getEntityClass()));
        }
        return this.queryFinder.find(name);
    }

    @Override
    public List<T> findByNamedQuery(String queryName, Map<String, Object> queryParams) {
        TypedQuery query = this.em.createNamedQuery(queryName, this.getEntityClass());
        if (queryParams != null) {
            for (Map.Entry<String, Object> entry : queryParams.entrySet()) {
                query.setParameter(entry.getKey(), entry.getValue());
            }
        }
        return query.getResultList();
    }

    @Override
    public T get(PK id) {
        return (T)this.em.find(this.getEntityClass(), id);
    }

    @Override
    public List<T> getAll() {
        CriteriaQuery q = this.em.getCriteriaBuilder().createQuery(this.getEntityClass());
        q.from(this.getEntityClass());
        return this.em.createQuery(q).getResultList();
    }

    @Override
    public void delete(T entity) {
        if (!this.em.contains(entity)) {
            entity = this.em.merge(entity);
        }
        if (this.onDeleteSetNull) {
            this.nullReferences(entity);
        }
        this.em.remove(entity);
    }

    @Override
    public void deleteById(PK id) {
        this.delete(this.get(id));
    }

    private void nullReferences(T entity) {
        EntityType type = this.em.getMetamodel().entity(this.getEntityClass());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Null references on entity " + type.getName()));
        }
        for (Attribute a : type.getAttributes()) {
            Object association;
            if (Attribute.PersistentAttributeType.ONE_TO_MANY != a.getPersistentAttributeType() && Attribute.PersistentAttributeType.ONE_TO_ONE != a.getPersistentAttributeType() || (association = PropertyAccessorFactory.forDirectFieldAccess(entity).getPropertyValue(a.getName())) == null) continue;
            EntityType associationType = null;
            associationType = a.isCollection() ? this.em.getMetamodel().entity(((PluralAttribute)a).getBindableJavaType()) : this.em.getMetamodel().entity(a.getJavaType());
            String mappedBy = JpaUtils.getMappedBy(a);
            if (mappedBy == null) continue;
            Attribute aa = associationType.getAttribute(mappedBy);
            if (Attribute.PersistentAttributeType.MANY_TO_ONE == aa.getPersistentAttributeType()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Null ManyToOne reference on " + associationType.getName() + "." + aa.getName()));
                }
                for (Object o : (Collection)association) {
                    PropertyAccessorFactory.forDirectFieldAccess(o).setPropertyValue(aa.getName(), null);
                }
                continue;
            }
            if (Attribute.PersistentAttributeType.ONE_TO_ONE != aa.getPersistentAttributeType()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Null OneToOne reference on " + associationType.getName() + "." + aa.getName()));
            }
            PropertyAccessorFactory.forDirectFieldAccess((Object)association).setPropertyValue(aa.getName(), null);
        }
    }

    @Override
    public boolean exists(PK id) {
        return id != null && this.get(id) != null;
    }

    @Override
    public T initialize(T entity) {
        this.initialize(entity, 2);
        return entity;
    }

    @Override
    public T initialize(T entity, int depth) {
        JpaUtils.initialize(this.em, entity, depth);
        return entity;
    }

    @Override
    public T save(T entity) {
        Object persistentEntity;
        if (this.isNew(entity)) {
            this.em.persist(entity);
            persistentEntity = entity;
        } else {
            persistentEntity = this.em.merge(entity);
        }
        return (T)persistentEntity;
    }

    protected boolean isNew(T entity) {
        SingularAttribute<?, ?> id = this.getIdAttribute(entity.getClass());
        ConfigurablePropertyAccessor pa = PropertyAccessorFactory.forDirectFieldAccess(entity);
        Serializable key = (Serializable)pa.getPropertyValue(id.getName());
        if (key == null) {
            key = (Serializable)PropertyAccessorFactory.forBeanPropertyAccess(entity).getPropertyValue(id.getName());
        }
        return key == null || !this.exists(key, entity.getClass());
    }

    private boolean exists(PK key, Class<? extends Object> clazz) {
        return this.get(key, clazz) != null;
    }

    @Override
    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    public Map<String, JpaCriteriaBuilder<?>> getCriteriaBuilderMap() {
        return this.criteriaBuilderMap;
    }

    public void setCriteriaBuilderMap(Map<String, JpaCriteriaBuilder<T>> criteriaBuilderMap) {
        this.criteriaBuilderMap.clear();
        this.criteriaBuilderMap.putAll(criteriaBuilderMap);
    }

    public QueryFinder getQueryFinder() {
        return this.queryFinder;
    }

    public void setQueryFinder(QueryFinder queryFinder) {
        this.queryFinder = queryFinder;
    }

    @Override
    public <E> E get(PK id, Class<E> clazz) {
        return (E)this.em.find(clazz, id);
    }

    @Override
    public <E> List<E> getAll(Class<E> clazz) {
        CriteriaQuery q = this.em.getCriteriaBuilder().createQuery(clazz);
        q.from(clazz);
        return this.em.createQuery(q).getResultList();
    }

    public EntityManager getEntityManager() {
        return this.em;
    }

    public void setEntityManager(EntityManager em) {
        this.em = em;
    }

    public void setEntityClass(Class<T> entityClass) {
        this.entityClass = entityClass;
    }

    public boolean isOnDeleteSetNull() {
        return this.onDeleteSetNull;
    }

    public void setOnDeleteSetNull(boolean onDeleteSetNull) {
        this.onDeleteSetNull = onDeleteSetNull;
    }
}

