/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.dao.jpa;

import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.jdal.dao.Filter;
import org.jdal.dao.jpa.JpaCriteriaBuilder;
import org.jdal.dao.jpa.JpaUtils;

public abstract class JpaCriteriaBuilderSupport<T, K>
implements JpaCriteriaBuilder<T> {
    protected Filter filter;
    protected Root<K> root;
    protected CriteriaBuilder cb;
    protected Class<K> entityClass;

    public JpaCriteriaBuilderSupport(Class<K> entityClass) {
        this.entityClass = entityClass;
    }

    @Override
    public synchronized CriteriaQuery<T> build(CriteriaQuery<T> criteria, CriteriaBuilder cb, Filter filter) {
        this.filter = filter;
        this.root = criteria.from(this.entityClass);
        this.cb = cb;
        this.doBuild(criteria, cb, filter);
        return criteria;
    }

    protected abstract void doBuild(CriteriaQuery<T> var1, CriteriaBuilder var2, Filter var3);

    protected Predicate equal(String propertyName, Object value) {
        if (value == null) {
            return null;
        }
        return this.cb.equal(JpaUtils.getPath(this.root, propertyName), value);
    }

    protected <Y extends Comparable<? super Y>> Predicate lessThanOrEqualTo(String propertyName, Y value) {
        if (value == null) {
            return null;
        }
        return this.cb.lessThanOrEqualTo(JpaUtils.getPath(this.root, propertyName), value);
    }

    protected <Y extends Comparable<? super Y>> Predicate greatThanOrEqualTo(String propertyName, Y value) {
        if (value == null) {
            return null;
        }
        return this.cb.greaterThanOrEqualTo(JpaUtils.getPath(this.root, propertyName), value);
    }

    protected Predicate like(String propertyName, String value) {
        if (value == null) {
            return null;
        }
        String toMatch = value.trim();
        toMatch = toMatch.replace('*', '%');
        toMatch = "%" + toMatch + "%";
        return this.cb.like(JpaUtils.getPath(this.root, propertyName), toMatch);
    }

    protected <Y> void addAndWhere(CriteriaQuery<Y> criteria, CriteriaBuilder cb, List<Predicate> predicates) {
        if (predicates.size() > 0) {
            criteria.where((Expression)cb.and(predicates.toArray(new Predicate[0])));
        }
    }

    protected <Y> Path<Y> getPath(Path<?> path, String name) {
        return JpaUtils.getPath(path, name);
    }

    protected void addPredicateIfNotNull(List<Predicate> predicates, Predicate predicate) {
        if (predicate != null) {
            predicates.add(predicate);
        }
    }
}

