/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.dao.hibernate;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.transform.ResultTransformer;

public class HibernateExecutable {
    public static final String LIST = "list";
    public static final String UNIQUE_RESULT = "uniqueResult";
    public static final String SET_MAX_RESULTS = "setMaxResults";
    public static final String SET_FIRST_RESULT = "setFirstResult";
    public static final String SET_RESULT_TRANSFORMER = "setResultTransformer";
    private static final Log log = LogFactory.getLog(HibernateExecutable.class);
    private Object executable;
    private Map<String, Method> methodMap = new HashMap<String, Method>();

    public HibernateExecutable(Criteria criteria) {
        this.executable = criteria;
    }

    public HibernateExecutable(Query query) {
        this.executable = query;
    }

    public List list() throws HibernateException {
        return (List)this.invoke(LIST, new Object[0]);
    }

    public Object uniqueResult() throws HibernateException {
        return this.invoke(UNIQUE_RESULT, new Object[0]);
    }

    private Object invoke(String name, Object ... args) {
        Method method = this.methodMap.get(name);
        if (method == null) {
            Class<?> clazz = this.executable.getClass();
            Class[] types = new Class[args.length];
            int i = 0;
            while (i < args.length) {
                types[i] = args[i].getClass();
                ++i;
            }
            try {
                method = ClassUtils.getPublicMethod(clazz, (String)name, (Class[])types);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            this.methodMap.put(name, method);
        }
        try {
            return method.invoke(this.executable, args);
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    public HibernateExecutable setMaxResults(int maxResults) {
        this.invoke(SET_MAX_RESULTS, maxResults);
        return this;
    }

    public HibernateExecutable setFirstResult(int firstResult) {
        this.invoke(SET_FIRST_RESULT, firstResult);
        return this;
    }

    public HibernateExecutable HibersetResultTransformer(ResultTransformer transformer) {
        this.invoke(SET_RESULT_TRANSFORMER, transformer);
        return this;
    }
}

