/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.dao.hibernate;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.LockOptions;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.impl.CriteriaImpl;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.Type;
import org.jdal.beans.PropertyUtils;
import org.jdal.dao.DaoSupport;
import org.jdal.dao.Filter;
import org.jdal.dao.Page;
import org.jdal.dao.hibernate.CriteriaBuilder;
import org.jdal.hibernate.HibernateUtils;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.util.ClassUtils;

public class HibernateDao<T, PK extends Serializable>
extends DaoSupport<T, PK> {
    private static final Log log = LogFactory.getLog(HibernateDao.class);
    private Class<T> entityClass;
    private boolean cachePageQueries = false;
    private HibernateTemplate hibernateTemplate;
    private Map<String, CriteriaBuilder> criteriaBuilderMap = Collections.synchronizedMap(new HashMap());

    public HibernateDao() {
    }

    public HibernateDao(Class<T> persistentClass) {
        this.entityClass = persistentClass;
    }

    @Override
    public <K> Page<K> getPage(Page<K> page) {
        List data = null;
        Query query = this.getQuery(page);
        if (query != null) {
            data = query.list();
        } else {
            Criteria criteria = this.getCriteria(page);
            ResultTransformer rt = ((CriteriaImpl)criteria).getResultTransformer();
            criteria.setProjection(Projections.rowCount());
            page.setCount(((Long)criteria.uniqueResult()).intValue());
            criteria.setProjection(null);
            criteria.setResultTransformer(rt);
            criteria.setFirstResult(page.getStartIndex()).setMaxResults(page.getPageSize());
            this.applyOrder(page, criteria);
            criteria.setCacheable(this.cachePageQueries);
            data = criteria.list();
        }
        page.setData(data);
        return page;
    }

    private Query getQuery(Page<?> page) {
        Object filter = page.getFilter();
        try {
            if (filter instanceof Filter) {
                Filter f = (Filter)filter;
                Query query = this.getSession().getNamedQuery(f.getFilterName());
                Query countQuery = this.getSession().createQuery(query.getQueryString().replaceFirst("select", "count"));
                query.setProperties(f.getParameterMap());
                query.setMaxResults(page.getPageSize());
                query.setFirstResult(page.getStartIndex());
                page.setCount((Integer)countQuery.uniqueResult());
                return query;
            }
        }
        catch (HibernateException hibernateException) {
            // empty catch block
        }
        return null;
    }

    private Criteria getCriteria(Page<?> page) {
        Criteria executableCriteria = this.getSession().createCriteria(this.getEntityClass());
        Object filter = page.getFilter();
        if (filter != null) {
            if (ClassUtils.isAssignable(this.getEntityClass(), filter.getClass())) {
                executableCriteria.add((Criterion)Example.create(this.getEntityClass()));
            } else if (filter instanceof Filter) {
                Filter f = (Filter)filter;
                if (!this.enableFilter(f)) {
                    Method method;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("No hibernate filter found with name: " + f.getFilterName() + ", try criteria builder."));
                    }
                    if (this.criteriaBuilderMap.containsKey(f.getFilterName())) {
                        CriteriaBuilder cb = this.criteriaBuilderMap.get(f.getFilterName());
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Found criteria builder with name: " + f.getFilterName() + " - criteria builder class: " + cb.getClass().getSimpleName()));
                        }
                        executableCriteria = cb.build(executableCriteria, f);
                    } else if (ClassUtils.hasMethod(this.getClass(), (String)("createCriteria" + f.getFilterName()), (Class[])new Class[]{Criteria.class}) && (method = ClassUtils.getMethodIfAvailable(this.getClass(), (String)("createCriteria" + f.getFilterName()), (Class[])new Class[]{Criteria.class})) != null) {
                        try {
                            executableCriteria = (Criteria)method.invoke((Object)this, executableCriteria);
                        }
                        catch (Exception e) {
                            log.error((Object)e);
                        }
                    }
                }
            } else {
                log.warn((Object)("Cannot manage filter of type: " + filter.getClass()));
            }
        }
        return executableCriteria;
    }

    public boolean enableFilter(Filter f) {
        if (this.getSessionFactory().getDefinedFilterNames().contains(f.getFilterName())) {
            org.hibernate.Filter hf = this.getSession().enableFilter(f.getFilterName());
            Map<String, Object> parameterMap = f.getParameterMap();
            for (String key : parameterMap.keySet()) {
                hf.setParameter(key, parameterMap.get(key));
            }
            return true;
        }
        return false;
    }

    private ClassMetadata getClassMetadata() {
        return this.getClassMetadata(this.getEntityClass());
    }

    private ClassMetadata getClassMetadata(Class<?> clazz) {
        return this.getHibernateTemplate().getSessionFactory().getClassMetadata(clazz);
    }

    protected void applyOrder(Page<?> page, Criteria criteria) {
        Order order = this.createOrder(criteria, page.getSortName(), Page.Order.ASC.equals((Object)page.getOrder()));
        if (order != null) {
            criteria.addOrder(order);
        }
    }

    protected Order createOrder(Criteria criteria, String propertyPath, boolean ascending) {
        Order order = null;
        if (propertyPath != null) {
            String sortProperty = PropertyUtils.getPropertyName(propertyPath);
            try {
                if (PropertyUtils.isNested(propertyPath)) {
                    String aliasPropertyPath = PropertyUtils.getPath(propertyPath);
                    String alias = HibernateUtils.findAliasForPropertyPath(criteria, propertyPath);
                    if (alias == null) {
                        alias = PropertyUtils.getPropertyName(aliasPropertyPath);
                        criteria.createAlias(aliasPropertyPath, alias);
                    }
                    sortProperty = String.valueOf(alias) + PropertyUtils.PROPERTY_SEPARATOR + sortProperty;
                } else {
                    Type sortType = this.getClassMetadata().getPropertyType(propertyPath);
                    if (sortType.isEntityType()) {
                        String[] propertyNames;
                        String[] stringArray = propertyNames = this.getClassMetadata(sortType.getReturnedClass()).getPropertyNames();
                        int n = propertyNames.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String name = stringArray[n2];
                            if ("name".equals(name)) {
                                log.info((Object)("Found property name on persistent class: " + sortType.getName()));
                                String newPath = String.valueOf(propertyPath) + "." + "name";
                                return this.createOrder(criteria, newPath, ascending);
                            }
                            ++n2;
                        }
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Setting order as: " + sortProperty));
                }
                order = ascending ? Order.asc((String)sortProperty) : Order.desc((String)sortProperty);
            }
            catch (HibernateException he) {
                log.error((Object)("Cannot to create Order for property: " + sortProperty + " for " + this.getEntityClass().getSimpleName()), (Throwable)he);
            }
        } else {
            ClassMetadata metadata = this.getClassMetadata();
            if (metadata != null) {
                order = Order.asc((String)metadata.getIdentifierPropertyName());
            }
        }
        return order;
    }

    @Override
    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    public void setEntityClass(Class<T> entityClass) {
        this.entityClass = entityClass;
    }

    @Override
    public void delete(T entity) {
        this.getHibernateTemplate().delete(entity);
    }

    @Override
    public T save(T entity) {
        this.getHibernateTemplate().saveOrUpdate(entity);
        return entity;
    }

    @Override
    public List<Serializable> getKeys(Page<T> page) {
        Criteria criteria = this.getCriteria(page);
        return criteria.setProjection((Projection)Projections.id()).list();
    }

    @Override
    public void deleteById(PK id) {
        this.getSession().delete(this.get(id));
    }

    @Override
    public T initialize(T entity) {
        this.getSession().buildLockRequest(LockOptions.NONE).lock(entity);
        HibernateUtils.initialize(this.getSessionFactory(), entity);
        return entity;
    }

    @Override
    public T initialize(T entity, int depth) {
        this.getSession().buildLockRequest(LockOptions.NONE).lock(entity);
        HibernateUtils.initialize(this.getSessionFactory(), entity, depth);
        return entity;
    }

    public Map<String, CriteriaBuilder> getCriteriaBuilderMap() {
        return this.criteriaBuilderMap;
    }

    public void setCriteriaBuilderMap(Map<String, CriteriaBuilder> criteriaBuilderMap) {
        this.criteriaBuilderMap.clear();
        this.criteriaBuilderMap.putAll(criteriaBuilderMap);
    }

    @Override
    public List<T> getAll() {
        return new ArrayList(this.getHibernateTemplate().loadAll(this.entityClass));
    }

    public List<T> getAllDistinct() {
        LinkedHashSet<T> result = new LinkedHashSet<T>(this.getAll());
        return new ArrayList<T>(result);
    }

    @Override
    public List<T> findByNamedQuery(String queryName, Map<String, Object> queryParams) {
        String[] params = new String[queryParams.size()];
        Object[] values = new Object[queryParams.size()];
        int index = 0;
        Iterator<String> i = queryParams.keySet().iterator();
        while (i.hasNext()) {
            String key;
            params[index] = key = i.next();
            values[index++] = queryParams.get(key);
        }
        return this.getHibernateTemplate().findByNamedQueryAndNamedParam(queryName, params, values);
    }

    @Override
    public T get(PK id) {
        Object entity = this.getHibernateTemplate().get(this.entityClass, id);
        if (entity == null) {
            log.warn((Object)("'" + this.entityClass.getSimpleName() + "' object with id '" + id + "' not found..."));
            throw new ObjectRetrievalFailureException(this.entityClass, id);
        }
        return (T)entity;
    }

    @Override
    public boolean exists(PK id) {
        return this.getHibernateTemplate().get(this.entityClass, id) != null;
    }

    public int count() {
        return ((Long)this.getSession().createCriteria(this.entityClass).setProjection(Projections.rowCount()).uniqueResult()).intValue();
    }

    public boolean isCachePageQueries() {
        return this.cachePageQueries;
    }

    public void setCachePageQueries(boolean cachePageQueries) {
        this.cachePageQueries = cachePageQueries;
    }

    @Override
    public <E> E get(PK id, Class<E> clazz) {
        return (E)this.getSession().get(clazz, id);
    }

    @Override
    public <E> List<E> getAll(Class<E> clazz) {
        return this.getSession().createCriteria(clazz).list();
    }

    public HibernateTemplate getHibernateTemplate() {
        return this.hibernateTemplate;
    }

    public void setHibernateTemplate(HibernateTemplate hibernateTemplate) {
        this.hibernateTemplate = hibernateTemplate;
    }

    public final void setSessionFactory(SessionFactory sessionFactory) {
        if (this.hibernateTemplate == null || sessionFactory != this.hibernateTemplate.getSessionFactory()) {
            this.hibernateTemplate = new HibernateTemplate(sessionFactory);
        }
    }

    public final SessionFactory getSessionFactory() {
        return this.hibernateTemplate != null ? this.hibernateTemplate.getSessionFactory() : null;
    }

    public Session getSession() {
        return this.hibernateTemplate.getSessionFactory().getCurrentSession();
    }
}

