/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.dao;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jdal.dao.Page;
import org.jdal.dao.PageableDataSource;

public class ListPageableDataSource<T>
implements PageableDataSource<T> {
    private List<T> list = new ArrayList<T>();

    public ListPageableDataSource() {
    }

    public ListPageableDataSource(Collection<T> c) {
        if (c != null) {
            this.list.addAll(c);
        }
    }

    @Override
    public <K> Page<K> getPage(Page<K> page) {
        if (this.list.isEmpty()) {
            page.setCount(0);
            page.setData(this.list);
            return page;
        }
        int startIndex = page.getStartIndex() < this.list.size() ? page.getStartIndex() : this.list.size() - 1;
        int toIndex = page.getStartIndex() + page.getPageSize();
        toIndex = toIndex < this.list.size() ? toIndex : this.list.size() - 1;
        page.setData(this.list.subList(startIndex, toIndex));
        page.setCount(this.list.size());
        return page;
    }

    @Override
    public List<Serializable> getKeys(Page<T> page) {
        return null;
    }

    public List<T> getList() {
        return this.list;
    }

    public void setList(List<T> list) {
        this.list = list;
    }
}

