/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.dao;

import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdal.dao.Filter;
import org.springframework.beans.BeanUtils;

public class BeanFilter
implements Filter,
Serializable {
    private static final Log log = LogFactory.getLog(BeanFilter.class);
    private String filterName;
    private List<String> ignoredProperties = new ArrayList<String>();
    private static final String PARAMETER_MAP = "parameterMap";
    private static final String FILTER_NAME = "filterName";

    public BeanFilter() {
        this.filterName = StringUtils.uncapitalize((String)this.getClass().getSimpleName());
        this.init();
    }

    public BeanFilter(String filterName) {
        this.filterName = filterName;
        this.init();
    }

    private void init() {
        this.ignoredProperties.add(PARAMETER_MAP);
        this.ignoredProperties.add(FILTER_NAME);
        this.ignoredProperties.add("class");
    }

    @Override
    public Map<String, Object> getParameterMap() {
        PropertyDescriptor[] pds = BeanUtils.getPropertyDescriptors(this.getClass());
        HashMap<String, Object> map = new HashMap<String, Object>();
        PropertyDescriptor[] propertyDescriptorArray = pds;
        int n = pds.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor pd = propertyDescriptorArray[n2];
            if (!this.ignoredProperties.contains(pd.getName())) {
                try {
                    map.put(pd.getName(), pd.getReadMethod().invoke((Object)this, null));
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
            ++n2;
        }
        return map;
    }

    @Override
    public void clear() {
        PropertyDescriptor[] pds;
        PropertyDescriptor[] propertyDescriptorArray = pds = BeanUtils.getPropertyDescriptors(this.getClass());
        int n = pds.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor pd = propertyDescriptorArray[n2];
            if (!this.ignoredProperties.contains(pd.getName())) {
                try {
                    pd.getWriteMethod().invoke((Object)this, new Object[]{null});
                }
                catch (Exception e) {
                    log.error((Object)("Error nullifing property: [" + pd.getName() + "]"), (Throwable)e);
                }
            }
            ++n2;
        }
    }

    @Override
    public String getFilterName() {
        return this.filterName;
    }

    public void setFilterName(String name) {
        this.filterName = name;
    }
}

