/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.beans;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.i18n.LocaleContextHolder;

public class StaticMessageSource {
    private static MessageSource messageSource = null;
    private static final Log log = LogFactory.getLog(StaticMessageSource.class);

    private StaticMessageSource(MessageSource messageSource) {
        StaticMessageSource.messageSource = messageSource;
    }

    public static MessageSource getMessageSource() {
        return messageSource;
    }

    public static void setMessageSource(MessageSource messageSource) {
        StaticMessageSource.messageSource = messageSource;
    }

    public static String getMessage(String code) {
        try {
            return messageSource == null ? code : messageSource.getMessage(code, null, LocaleContextHolder.getLocale());
        }
        catch (Exception e) {
            log.error((Object)e);
            return code;
        }
    }

    public static String getMessage(MessageSourceResolvable msr) {
        return messageSource == null ? msr.getDefaultMessage() : messageSource.getMessage(msr, LocaleContextHolder.getLocale());
    }

    public static String getMessage(String code, Object[] args) {
        return messageSource.getMessage(code, args, LocaleContextHolder.getLocale());
    }
}

