/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.beans;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ListFactoryBean;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class ListBeanDefinitionParser
extends AbstractSimpleBeanDefinitionParser {
    private static final String SCOPE_ATTRIBUTE = "scope";
    private String defaultScope = "prototype";

    public ListBeanDefinitionParser(String defaultScope) {
        this.defaultScope = defaultScope;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        List columns = parserContext.getDelegate().parseListElement(element, (BeanDefinition)builder.getRawBeanDefinition());
        builder.addPropertyValue("sourceList", (Object)columns);
        String scope = element.getAttribute(SCOPE_ATTRIBUTE);
        if (StringUtils.isEmpty((String)scope)) {
            scope = this.defaultScope;
        }
        builder.setScope(this.defaultScope);
    }

    protected Class<?> getBeanClass(Element element) {
        return ListFactoryBean.class;
    }
}

