/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.beans;

import java.util.Properties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

public class AppCtx {
    private static ClassPathXmlApplicationContext context = null;
    private static PropertySource<?> propertySource;
    private static String config;

    public static synchronized ApplicationContext getInstance() {
        if (context == null) {
            context = new ClassPathXmlApplicationContext();
            if (propertySource != null) {
                context.getEnvironment().getPropertySources().addFirst(propertySource);
            }
            String location = "classpath*:/" + (config != null ? String.valueOf(config) + "/" : "") + "applicationContext*.xml";
            context.setConfigLocation(location);
            context.refresh();
        }
        return context;
    }

    public static synchronized void setProperties(String name, Properties properties) {
        propertySource = new PropertiesPropertySource(name, properties);
    }

    public static void setConfigPackage(String config) {
        AppCtx.config = config;
    }
}

