/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.aop.config;

import org.jdal.aop.SerializableProxyUtils;
import org.jdal.aop.SerializableTargetSource;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.ProxyConfig;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class SerializableProxyFactoryBean
extends ProxyConfig
implements FactoryBean<Object>,
BeanFactoryAware {
    private ConfigurableListableBeanFactory beanFactory;
    private boolean singleton;
    private String targetBeanName;
    private Object proxy;

    public SerializableProxyFactoryBean() {
        this.setProxyTargetClass(true);
    }

    public Object getObject() throws Exception {
        if (this.isSingleton()) {
            if (this.proxy == null) {
                this.proxy = this.createProxy();
            }
            return this.proxy;
        }
        return this.createProxy();
    }

    protected Object createProxy() {
        Object target = this.beanFactory.getBean(this.targetBeanName);
        return SerializableProxyUtils.createSerializableProxy(target, this.isProxyTargetClass(), false, this.beanFactory, this.targetBeanName);
    }

    protected TargetSource createTargetSource() {
        return new SerializableTargetSource((BeanFactory)this.beanFactory, this.targetBeanName, !this.isSingleton());
    }

    public Class<?> getObjectType() {
        if (this.beanFactory != null) {
            return this.beanFactory.getType(this.targetBeanName);
        }
        return null;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public String getTargetBeanName() {
        return this.targetBeanName;
    }

    public void setTargetBeanName(String targetBeanName) {
        this.targetBeanName = targetBeanName;
    }
}

