/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.aop.config;

import org.jdal.aop.SerializableProxyUtils;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionDecorator;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SerializableProxyBeanDefinitionDecorator
implements BeanDefinitionDecorator {
    private static final String PROXY_TARGET_CLASS = "proxy-target-class";

    public BeanDefinitionHolder decorate(Node node, BeanDefinitionHolder definition, ParserContext parserContext) {
        Element ele;
        boolean proxyTargetClass = true;
        if (node instanceof Element && (ele = (Element)node).hasAttribute(PROXY_TARGET_CLASS)) {
            proxyTargetClass = Boolean.valueOf(ele.getAttribute(PROXY_TARGET_CLASS));
        }
        BeanDefinitionHolder holder = SerializableProxyUtils.createSerializableProxy(definition, parserContext.getRegistry(), proxyTargetClass);
        String targetBeanName = SerializableProxyUtils.getTargetBeanName(definition.getBeanName());
        parserContext.getReaderContext().fireComponentRegistered((ComponentDefinition)new BeanComponentDefinition(definition.getBeanDefinition(), targetBeanName));
        return holder;
    }
}

