/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.aop.config;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdal.annotation.AnnotatedElementAccessor;
import org.jdal.annotation.SerializableProxy;
import org.jdal.aop.SerializableAopProxy;
import org.jdal.aop.SerializableProxyUtils;
import org.springframework.aop.framework.AopInfrastructureBean;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationUtils;

public class SerializableAnnotationBeanPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter
implements BeanFactoryAware {
    private static final Log log = LogFactory.getLog(SerializableAnnotationBeanPostProcessor.class);
    private ConfigurableListableBeanFactory beanFactory;

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof SerializableAopProxy || bean instanceof AopInfrastructureBean || beanName.startsWith("jdalSerializableProxy.")) {
            return bean;
        }
        SerializableProxy ann = (SerializableProxy)AnnotationUtils.findAnnotation(bean.getClass(), SerializableProxy.class);
        if (ann != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating serializable proxy for bean [" + beanName + "]"));
            }
            boolean proxyTargetClass = !this.beanFactory.getType(beanName).isInterface() || ann.proxyTargetClass();
            return SerializableProxyUtils.createSerializableProxy(bean, proxyTargetClass, ann.useCache(), this.beanFactory, beanName);
        }
        return bean;
    }

    protected Object getProxy(Object target, boolean proxyTargetClass, boolean useCache, DependencyDescriptor descriptor, String beanName) {
        return SerializableProxyUtils.createSerializableProxy(target, proxyTargetClass, useCache, this.beanFactory, descriptor, beanName);
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    protected DependencyDescriptor getDependencyDescriptor(AnnotatedElement ae) {
        return new DependencyDescriptor((Field)ae, false);
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        List<AnnotatedElement> elements = AnnotatedElementAccessor.findAnnotatedElements(SerializableProxy.class, bean.getClass());
        for (AnnotatedElement element : elements) {
            ResolvableType type = this.getResolvableType(element);
            Object value = AnnotatedElementAccessor.getValue(element, bean);
            if (value == null || value instanceof SerializableAopProxy) continue;
            SerializableProxy ann = (SerializableProxy)AnnotationUtils.getAnnotation((AnnotatedElement)element, SerializableProxy.class);
            boolean proxyTargetClass = !type.resolve().isInterface() || ann.proxyTargetClass();
            Object proxy = this.getProxy(value, proxyTargetClass, ann.useCache(), this.getDependencyDescriptor(element), beanName);
            if (proxy == null) continue;
            AnnotatedElementAccessor.setValue(element, bean, proxy);
        }
        return bean;
    }

    private ResolvableType getResolvableType(AnnotatedElement element) {
        if (element instanceof Field) {
            return ResolvableType.forField((Field)((Field)element));
        }
        if (element instanceof Method) {
            return ResolvableType.forMethodParameter((MethodParameter)new MethodParameter((Method)element, 0));
        }
        throw new IllegalArgumentException("SerializableProxy annotation should only be applied on types, fields or methods but was found in [" + element.toString() + "]");
    }
}

