/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

public abstract class AnnotatedElementAccessor {
    private static final Log log = LogFactory.getLog(AnnotatedElementAccessor.class);

    public static List<AnnotatedElement> findAnnotatedElements(final Class<? extends Annotation> annotationType, Class<?> clazz) {
        final ArrayList<AnnotatedElement> elements = new ArrayList<AnnotatedElement>();
        ReflectionUtils.doWithFields(clazz, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                if (field.getAnnotation(annotationType) != null) {
                    elements.add(field);
                }
            }
        });
        ReflectionUtils.doWithMethods(clazz, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                if (AnnotationUtils.getAnnotation((Method)method, (Class)annotationType) != null) {
                    elements.add(method);
                }
            }
        });
        return elements;
    }

    public static void setValue(AnnotatedElement element, Object target, Object value) {
        if (element instanceof Field) {
            Field field = (Field)element;
            ReflectionUtils.makeAccessible((Field)field);
            ReflectionUtils.setField((Field)field, (Object)target, (Object)value);
        } else if (element instanceof Method) {
            Method method = (Method)element;
            try {
                method.invoke(target, value);
            }
            catch (Exception e) {
                log.error((Object)("Cannot set value on method [" + method.toString() + "]"));
            }
        }
    }

    public static Object getValue(AnnotatedElement element, Object target) {
        Method method;
        String name;
        if (element instanceof Field) {
            ReflectionUtils.makeAccessible((Field)((Field)element));
            return ReflectionUtils.getField((Field)((Field)element), (Object)target);
        }
        if (element instanceof Method && (name = (method = (Method)element).getName()).startsWith("set")) {
            return PropertyAccessorFactory.forBeanPropertyAccess((Object)target).getPropertyValue(AnnotatedElementAccessor.getPropertyName(name));
        }
        return null;
    }

    private static String getPropertyName(String name) {
        return String.valueOf(name.charAt(0)) + name.substring(1);
    }
}

