/*
 * Copyright (c) 2008, 2019 Emmanuel Dupuy.
 * This project is distributed under the GPLv3 license.
 * This is a Copyleft license that gives the user the right to use,
 * copy and modify the code freely for non-commercial purposes.
 */

package org.jd.core.v1.model.javasyntax.expression;

import org.jd.core.v1.model.javasyntax.type.Type;

public class SuperExpression extends AbstractLineNumberExpression {
    protected Type type;

    public SuperExpression(Type type) {
        this.type = type;
    }

    public SuperExpression(int lineNumber, Type type) {
        super(lineNumber);
        this.type = type;
    }

    @Override
    public Type getType() {
        return type;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        return "SuperExpression{" + type + "}";
    }
}
