/*
 * Copyright (c) 2008-2019 Emmanuel Dupuy.
 * This project is distributed under the GPLv3 license.
 * This is a Copyleft license that gives the user the right to use,
 * copy and modify the code freely for non-commercial purposes.
 */

package org.jd.core.v1.model.javasyntax.expression;

import org.jd.core.v1.model.javasyntax.declaration.BaseFormalParameter;
import org.jd.core.v1.model.javasyntax.statement.BaseStatement;
import org.jd.core.v1.model.javasyntax.type.Type;

public class LambdaFormalParametersExpression extends AbstractLambdaExpression {
    protected BaseFormalParameter parameters;

    public LambdaFormalParametersExpression(Type type, BaseFormalParameter parameters, BaseStatement statements) {
        super(type, statements);
        this.parameters = parameters;
    }

    public LambdaFormalParametersExpression(int lineNumber, Type type, BaseFormalParameter parameters, BaseStatement statements) {
        super(lineNumber, type, statements);
        this.parameters = parameters;
    }

    public BaseFormalParameter getParameters() {
        return parameters;
    }

    public void setParameters(BaseFormalParameter parameters) {
        this.parameters = parameters;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        return "LambdaFormalParametersExpression{" + parameters + " -> " + statements + "}";
    }
}
