/*
 * Decompiled with CFR 0.152.
 */
package org.jctools.queues;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.jctools.queues.LinkedArrayQueueUtil;
import org.jctools.queues.MessagePassingQueue;
import org.jctools.queues.MessagePassingQueueUtil;
import org.jctools.queues.MpscBlockingConsumerArrayQueueConsumerFields;
import org.jctools.queues.QueueProgressIndicators;
import org.jctools.util.Pow2;
import org.jctools.util.RangeUtil;
import org.jctools.util.UnsafeRefArrayAccess;

public class MpscBlockingConsumerArrayQueue<E>
extends MpscBlockingConsumerArrayQueueConsumerFields<E>
implements MessagePassingQueue<E>,
QueueProgressIndicators,
BlockingQueue<E> {
    long p0;
    long p1;
    long p2;
    long p3;
    long p4;
    long p5;
    long p6;
    long p7;
    long p10;
    long p11;
    long p12;
    long p13;
    long p14;
    long p15;
    long p16;
    long p17;
    private static final int CONTINUE_TO_P_INDEX_CAS = 0;
    private static final int RETRY = 1;
    private static final int QUEUE_FULL = 2;

    public MpscBlockingConsumerArrayQueue(int capacity) {
        super(Pow2.roundToPowerOfTwo(capacity) - 1 << 1, UnsafeRefArrayAccess.allocateRefArray(Pow2.roundToPowerOfTwo(capacity)));
        RangeUtil.checkGreaterThanOrEqual(capacity, 1, "capacity");
        this.soProducerLimit(Pow2.roundToPowerOfTwo(capacity) - 1 << 1);
    }

    @Override
    public final Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int size() {
        long currentProducerIndex;
        long before;
        long after = this.lvConsumerIndex();
        do {
            before = after;
            currentProducerIndex = this.lvProducerIndex();
        } while (before != (after = this.lvConsumerIndex()));
        long size = currentProducerIndex - after >> 1;
        if (size > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)size;
    }

    @Override
    public final boolean isEmpty() {
        return this.lvConsumerIndex() / 2L == this.lvProducerIndex() / 2L;
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public boolean offer(E e) {
        long pIndex;
        if (null == e) {
            throw new NullPointerException();
        }
        long mask = this.producerMask;
        Object[] buffer = this.producerBuffer;
        while (true) {
            if (((pIndex = this.lvProducerIndex()) & 1L) == 1L) {
                if (!this.offerAndWakeup(buffer, mask, pIndex, e)) continue;
                return true;
            }
            long producerLimit = this.lvProducerLimit();
            if (producerLimit <= pIndex && !this.recalculateProducerLimit(mask, pIndex, producerLimit)) {
                return false;
            }
            if (this.casProducerIndex(pIndex, pIndex + 2L)) break;
        }
        long offset = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(pIndex, mask);
        UnsafeRefArrayAccess.soRefElement(buffer, offset, e);
        return true;
    }

    @Override
    public void put(E e) throws InterruptedException {
        if (!this.offer(e)) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        if (this.offer(e)) {
            return true;
        }
        throw new UnsupportedOperationException();
    }

    private boolean offerAndWakeup(E[] buffer, long mask, long pIndex, E e) {
        long offset = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(pIndex, mask);
        Thread consumerThread = this.lvBlocked();
        if (consumerThread == null) {
            return false;
        }
        if (!this.casProducerIndex(pIndex, pIndex + 1L)) {
            return false;
        }
        UnsafeRefArrayAccess.soRefElement(buffer, offset, e);
        this.soBlocked(null);
        LockSupport.unpark(consumerThread);
        return true;
    }

    private boolean recalculateProducerLimit(long mask, long pIndex, long producerLimit) {
        long bufferCapacity;
        long cIndex = this.lvConsumerIndex();
        if (cIndex + (bufferCapacity = mask + 2L) <= pIndex) {
            if (pIndex - cIndex == bufferCapacity) {
                return false;
            }
            throw new IllegalStateException();
        }
        this.casProducerLimit(producerLimit, cIndex + bufferCapacity);
        return true;
    }

    private void wakeupConsumer() {
        Thread consumerThread;
        while ((consumerThread = this.lvBlocked()) == null) {
        }
        this.soBlocked(null);
        LockSupport.unpark(consumerThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E take() throws InterruptedException {
        Object[] buffer = this.consumerBuffer;
        long mask = this.consumerMask;
        long cIndex = this.lpConsumerIndex();
        long offset = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(cIndex, mask);
        Object e = UnsafeRefArrayAccess.lvRefElement(buffer, offset);
        if (e == null) {
            long pIndex = this.lvProducerIndex();
            if (cIndex == pIndex && this.casProducerIndex(pIndex, pIndex + 1L)) {
                boolean unblocked = false;
                try {
                    this.soBlocked(Thread.currentThread());
                    do {
                        LockSupport.park();
                        if (!Thread.interrupted()) continue;
                        throw new InterruptedException();
                    } while (this.lvBlocked() != null);
                    unblocked = true;
                }
                finally {
                    if (!unblocked && this.casProducerIndex(pIndex + 1L, pIndex)) {
                        this.soBlocked(null);
                    }
                }
            }
            e = this.spinWaitForElement(buffer, offset);
        }
        UnsafeRefArrayAccess.soRefElement(buffer, offset, null);
        this.soConsumerIndex(cIndex + 2L);
        return (E)e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        long remainingNanos = unit.toNanos(timeout);
        Object[] buffer = this.consumerBuffer;
        long mask = this.consumerMask;
        long cIndex = this.lpConsumerIndex();
        long offset = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(cIndex, mask);
        Object e = UnsafeRefArrayAccess.lvRefElement(buffer, offset);
        if (e == null) {
            if (remainingNanos <= 0L) {
                return null;
            }
            long pIndex = this.lvProducerIndex();
            if (cIndex == pIndex && this.casProducerIndex(pIndex, pIndex + 1L)) {
                boolean unblocked = false;
                try {
                    block10: {
                        this.soBlocked(Thread.currentThread());
                        long deadlineNanos = System.nanoTime() + remainingNanos;
                        do {
                            LockSupport.parkNanos(this, remainingNanos);
                            if (Thread.interrupted()) {
                                throw new InterruptedException();
                            }
                            if (this.lvBlocked() == null) break block10;
                        } while ((remainingNanos = deadlineNanos - System.nanoTime()) > 0L);
                        E e2 = null;
                        return e2;
                    }
                    unblocked = true;
                }
                finally {
                    if (!unblocked && this.casProducerIndex(pIndex + 1L, pIndex)) {
                        this.soBlocked(null);
                    }
                }
            }
            e = this.spinWaitForElement(buffer, offset);
        }
        UnsafeRefArrayAccess.soRefElement(buffer, offset, null);
        this.soConsumerIndex(cIndex + 2L);
        return (E)e;
    }

    @Override
    public int remainingCapacity() {
        return this.capacity() - this.size();
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E poll() {
        Object[] buffer = this.consumerBuffer;
        long mask = this.consumerMask;
        long index = this.lpConsumerIndex();
        long offset = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(index, mask);
        Object e = UnsafeRefArrayAccess.lvRefElement(buffer, offset);
        if (e == null) {
            if (index != this.lvProducerIndex()) {
                e = this.spinWaitForElement(buffer, offset);
            } else {
                return null;
            }
        }
        UnsafeRefArrayAccess.soRefElement(buffer, offset, null);
        this.soConsumerIndex(index + 2L);
        return (E)e;
    }

    private Object spinWaitForElement(E[] buffer, long offset) {
        E e;
        while ((e = UnsafeRefArrayAccess.lvRefElement(buffer, offset)) == null) {
        }
        return e;
    }

    @Override
    public E peek() {
        Object[] buffer = this.consumerBuffer;
        long mask = this.consumerMask;
        long index = this.lpConsumerIndex();
        long offset = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(index, mask);
        Object e = UnsafeRefArrayAccess.lvRefElement(buffer, offset);
        if (e == null && index != this.lvProducerIndex()) {
            e = this.spinWaitForElement(buffer, offset);
        }
        return (E)e;
    }

    @Override
    public long currentProducerIndex() {
        return this.lvProducerIndex() / 2L;
    }

    @Override
    public long currentConsumerIndex() {
        return this.lvConsumerIndex() / 2L;
    }

    @Override
    public int capacity() {
        return (int)(this.consumerMask + 2L >> 1);
    }

    @Override
    public boolean relaxedOffer(E e) {
        return this.offer(e);
    }

    @Override
    public E relaxedPoll() {
        long mask;
        Object[] buffer = this.consumerBuffer;
        long index = this.lpConsumerIndex();
        long offset = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(index, mask = this.consumerMask);
        Object e = UnsafeRefArrayAccess.lvRefElement(buffer, offset);
        if (e == null) {
            return null;
        }
        UnsafeRefArrayAccess.soRefElement(buffer, offset, null);
        this.soConsumerIndex(index + 2L);
        return (E)e;
    }

    @Override
    public E relaxedPeek() {
        Object[] buffer = this.consumerBuffer;
        long index = this.lpConsumerIndex();
        long mask = this.consumerMask;
        long offset = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(index, mask);
        Object e = UnsafeRefArrayAccess.lvRefElement(buffer, offset);
        return (E)e;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s, int limit) {
        long pIndex;
        if (null == s) {
            throw new IllegalArgumentException("supplier is null");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("limit is negative:" + limit);
        }
        if (limit == 0) {
            return 0;
        }
        long mask = this.producerMask;
        Object[] buffer = this.producerBuffer;
        boolean wakeup = false;
        long batchIndex = 0L;
        long shiftedBatchSize = 2L * (long)limit;
        while (true) {
            pIndex = this.lvProducerIndex();
            long producerLimit = this.lvProducerLimit();
            if ((pIndex & 1L) == 1L) {
                if (!this.casProducerIndex(pIndex, pIndex + 1L)) continue;
                wakeup = true;
                batchIndex = pIndex + 1L;
                --pIndex;
                break;
            }
            batchIndex = Math.min(producerLimit, pIndex + shiftedBatchSize);
            if (pIndex >= producerLimit) {
                if (!this.recalculateProducerLimit(mask, pIndex, producerLimit)) {
                    return 0;
                }
                batchIndex = Math.min(this.lvProducerLimit(), pIndex + shiftedBatchSize);
            }
            if (this.casProducerIndex(pIndex, batchIndex)) break;
        }
        int claimedSlots = (int)((batchIndex - pIndex) / 2L);
        for (int i = 0; i < claimedSlots; ++i) {
            long offset = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(pIndex + 2L * (long)i, mask);
            UnsafeRefArrayAccess.soRefElement(buffer, offset, s.get());
        }
        if (wakeup) {
            this.wakeupConsumer();
        }
        return claimedSlots;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s) {
        return MessagePassingQueueUtil.fillBounded(this, s);
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> s, MessagePassingQueue.WaitStrategy wait, MessagePassingQueue.ExitCondition exit) {
        MessagePassingQueueUtil.fill(this, s, wait, exit);
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c) {
        return this.drain(c, this.capacity());
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c, int limit) {
        return MessagePassingQueueUtil.drain(this, c, limit);
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> c, MessagePassingQueue.WaitStrategy w, MessagePassingQueue.ExitCondition exit) {
        MessagePassingQueueUtil.drain(this, c, w, exit);
    }
}

