/*
 * Decompiled with CFR 0.152.
 */
package org.jctools.queues;

import java.util.Iterator;
import org.jctools.queues.CircularArrayOffsetCalculator;
import org.jctools.queues.ConcurrentCircularArrayQueueL0Pad;
import org.jctools.queues.IndexedQueueSizeUtil;
import org.jctools.util.Pow2;

public abstract class ConcurrentCircularArrayQueue<E>
extends ConcurrentCircularArrayQueueL0Pad<E> {
    protected final long mask;
    protected final E[] buffer;

    public ConcurrentCircularArrayQueue(int capacity) {
        int actualCapacity = Pow2.roundToPowerOfTwo(capacity);
        this.mask = actualCapacity - 1;
        this.buffer = CircularArrayOffsetCalculator.allocate(actualCapacity);
    }

    protected final long calcElementOffset(long index) {
        return ConcurrentCircularArrayQueue.calcElementOffset(index, this.mask);
    }

    protected static long calcElementOffset(long index, long mask) {
        return CircularArrayOffsetCalculator.calcElementOffset(index, mask);
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        while (this.poll() != null || !this.isEmpty()) {
        }
    }

    @Override
    public int capacity() {
        return (int)(this.mask + 1L);
    }

    @Override
    public final int size() {
        return IndexedQueueSizeUtil.size(this);
    }

    @Override
    public final boolean isEmpty() {
        return IndexedQueueSizeUtil.isEmpty(this);
    }

    @Override
    public final long currentProducerIndex() {
        return this.lvProducerIndex();
    }

    @Override
    public final long currentConsumerIndex() {
        return this.lvConsumerIndex();
    }
}

