/*
 * Decompiled with CFR 0.152.
 */
package org.jctools.queues.atomic;

import java.util.concurrent.atomic.AtomicReferenceArray;
import org.jctools.queues.SpscArrayQueue;
import org.jctools.queues.atomic.BaseSpscLinkedAtomicArrayQueue;
import org.jctools.util.Pow2;
import org.jctools.util.RangeUtil;

public class SpscGrowableAtomicArrayQueue<E>
extends BaseSpscLinkedAtomicArrayQueue<E> {
    private int maxQueueCapacity;
    private long lookAheadStep;

    public SpscGrowableAtomicArrayQueue(int capacity) {
        this(Math.max(8, Pow2.roundToPowerOfTwo(capacity / 8)), capacity);
    }

    public SpscGrowableAtomicArrayQueue(int chunkSize, int capacity) {
        AtomicReferenceArray buffer;
        RangeUtil.checkGreaterThanOrEqual(capacity, 16, "capacity");
        RangeUtil.checkGreaterThanOrEqual(chunkSize, 8, "chunkSize");
        this.maxQueueCapacity = Pow2.roundToPowerOfTwo(capacity);
        int chunkCapacity = Pow2.roundToPowerOfTwo(chunkSize);
        RangeUtil.checkLessThan(chunkCapacity, this.maxQueueCapacity, "chunkCapacity");
        long mask = chunkCapacity - 1;
        this.producerBuffer = buffer = SpscGrowableAtomicArrayQueue.allocate(chunkCapacity + 1);
        this.producerMask = mask;
        this.consumerBuffer = buffer;
        this.consumerMask = mask;
        this.producerBufferLimit = mask - 1L;
        this.adjustLookAheadStep(chunkCapacity);
        this.soProducerIndex(0L);
    }

    @Override
    protected final boolean offerColdPath(AtomicReferenceArray<E> buffer, long mask, E e, long index, int offset) {
        int maxCapacity;
        long lookAheadStep = this.lookAheadStep;
        if (lookAheadStep > 0L) {
            int lookAheadElementOffset = SpscGrowableAtomicArrayQueue.calcElementOffset(index + lookAheadStep, mask);
            if (null == this.lvElement(buffer, lookAheadElementOffset)) {
                this.producerBufferLimit = index + lookAheadStep - 1L;
                this.writeToQueue(buffer, e, index, offset);
                return true;
            }
            int maxCapacity2 = this.maxQueueCapacity;
            if (mask + 1L == (long)maxCapacity2) {
                if (null == this.lvElement(buffer, offset)) {
                    this.writeToQueue(buffer, e, index, offset);
                    return true;
                }
                return false;
            }
            if (null == this.lvElement(buffer, SpscGrowableAtomicArrayQueue.calcElementOffset(index + 1L, mask))) {
                this.writeToQueue(buffer, e, index, offset);
            } else {
                AtomicReferenceArray newBuffer;
                this.producerBuffer = newBuffer = SpscGrowableAtomicArrayQueue.allocate((int)(2L * (mask + 1L) + 1L));
                this.producerMask = newBuffer.length() - 2;
                int offsetInNew = SpscGrowableAtomicArrayQueue.calcElementOffset(index, this.producerMask);
                this.linkOldToNew(index, buffer, offset, newBuffer, offsetInNew, e);
                int newCapacity = (int)(this.producerMask + 1L);
                if (newCapacity == maxCapacity2) {
                    long currConsumerIndex = this.lvConsumerIndex();
                    this.lookAheadStep = -(index - currConsumerIndex);
                    this.producerBufferLimit = currConsumerIndex + (long)maxCapacity2 - 1L;
                } else {
                    this.producerBufferLimit = index + this.producerMask - 1L;
                    this.adjustLookAheadStep(newCapacity);
                }
            }
            return true;
        }
        long prevElementsInOtherBuffers = -lookAheadStep;
        long currConsumerIndex = this.lvConsumerIndex();
        int size = (int)(index - currConsumerIndex);
        if (size == (maxCapacity = (int)mask + 1)) {
            return false;
        }
        long firstIndexInCurrentBuffer = this.producerBufferLimit - (long)maxCapacity + prevElementsInOtherBuffers;
        if (currConsumerIndex >= firstIndexInCurrentBuffer) {
            this.adjustLookAheadStep(maxCapacity);
        } else {
            this.lookAheadStep = (int)(currConsumerIndex - firstIndexInCurrentBuffer);
        }
        this.producerBufferLimit = currConsumerIndex + (long)maxCapacity;
        this.writeToQueue(buffer, e, index, offset);
        return true;
    }

    private void adjustLookAheadStep(int capacity) {
        this.lookAheadStep = Math.min(capacity / 4, SpscArrayQueue.MAX_LOOK_AHEAD_STEP);
    }
}

