/*
 * Decompiled with CFR 0.152.
 */
package org.jctools.queues;

import org.jctools.queues.BaseSpscLinkedArrayQueue;
import org.jctools.queues.CircularArrayOffsetCalculator;
import org.jctools.util.Pow2;
import org.jctools.util.UnsafeRefArrayAccess;

public class SpscChunkedArrayQueue<E>
extends BaseSpscLinkedArrayQueue<E> {
    private int maxQueueCapacity;
    private long producerQueueLimit;

    public SpscChunkedArrayQueue(int capacity) {
        this(Math.max(8, Pow2.roundToPowerOfTwo(capacity / 8)), capacity);
    }

    public SpscChunkedArrayQueue(int chunkSize, int capacity) {
        if (capacity < 16) {
            throw new IllegalArgumentException("Max capacity must be 4 or more");
        }
        if (chunkSize < 8) {
            throw new IllegalArgumentException("Chunk size must be 2 or more");
        }
        this.maxQueueCapacity = Pow2.roundToPowerOfTwo(capacity);
        int chunkCapacity = Pow2.roundToPowerOfTwo(chunkSize);
        if (chunkCapacity >= this.maxQueueCapacity) {
            throw new IllegalArgumentException("Initial capacity cannot exceed maximum capacity(both rounded up to a power of 2)");
        }
        long mask = chunkCapacity - 1;
        E[] buffer = CircularArrayOffsetCalculator.allocate(chunkCapacity + 1);
        this.producerBuffer = buffer;
        this.producerMask = mask;
        this.consumerBuffer = buffer;
        this.consumerMask = mask;
        this.producerBufferLimit = mask - 1L;
        this.producerQueueLimit = this.maxQueueCapacity;
        this.soProducerIndex(0L);
    }

    @Override
    protected final boolean offerColdPath(E[] buffer, long mask, E e, long pIndex, long offset) {
        long lookAheadStep = (mask + 1L) / 4L;
        long pBufferLimit = pIndex + lookAheadStep;
        long pQueueLimit = this.producerQueueLimit;
        if (pIndex >= pQueueLimit) {
            long cIndex = this.lvConsumerIndex();
            this.producerQueueLimit = pQueueLimit = cIndex + (long)this.maxQueueCapacity;
            if (pIndex >= pQueueLimit) {
                return false;
            }
        }
        if (pBufferLimit - pQueueLimit > 0L) {
            pBufferLimit = pQueueLimit;
        }
        if (pBufferLimit > pIndex + 1L && null == UnsafeRefArrayAccess.lvElement(buffer, CircularArrayOffsetCalculator.calcElementOffset(pBufferLimit, mask))) {
            this.producerBufferLimit = pBufferLimit - 1L;
            this.writeToQueue(buffer, e, pIndex, offset);
        } else if (null == UnsafeRefArrayAccess.lvElement(buffer, CircularArrayOffsetCalculator.calcElementOffset(pIndex + 1L, mask))) {
            this.writeToQueue(buffer, e, pIndex, offset);
        } else {
            E[] newBuffer = CircularArrayOffsetCalculator.allocate((int)(mask + 2L));
            this.producerBuffer = newBuffer;
            this.linkOldToNew(pIndex, buffer, offset, newBuffer, offset, e);
        }
        return true;
    }
}

