/*
 * Decompiled with CFR 0.152.
 */
package org.jctools.queues;

import java.lang.reflect.Field;
import java.util.Iterator;
import org.jctools.queues.CircularArrayOffsetCalculator;
import org.jctools.queues.QueueProgressIndicators;
import org.jctools.queues.SpscArrayQueue;
import org.jctools.queues.SpscGrowableArrayQueueConsumerFields;
import org.jctools.queues.SpscGrowableArrayQueueProducerFields;
import org.jctools.util.Pow2;
import org.jctools.util.UnsafeAccess;
import org.jctools.util.UnsafeRefArrayAccess;

public class SpscGrowableArrayQueue<E>
extends SpscGrowableArrayQueueConsumerFields<E>
implements QueueProgressIndicators {
    private static final long P_INDEX_OFFSET;
    private static final long C_INDEX_OFFSET;
    private static final Object JUMP;

    public SpscGrowableArrayQueue(int capacity) {
        this(Pow2.roundToPowerOfTwo(Math.max(capacity, 32) / 2), Math.max(capacity, 32));
    }

    public SpscGrowableArrayQueue(int initialCapacity, int capacity) {
        int p2initialCapacity = Pow2.roundToPowerOfTwo(Math.max(initialCapacity, 32) / 2);
        int p2capacity = Pow2.roundToPowerOfTwo(Math.max(capacity, 32));
        if (p2initialCapacity >= p2capacity) {
            throw new IllegalArgumentException("Initial capacity(" + initialCapacity + ") rounded up to a power of 2 cannot exceed maximum capacity (" + capacity + ")rounded up to a power of 2");
        }
        long mask = p2initialCapacity - 1;
        E[] buffer = CircularArrayOffsetCalculator.allocate(p2initialCapacity + 1);
        this.producerBuffer = buffer;
        this.producerMask = mask;
        this.adjustLookAheadStep(p2initialCapacity);
        this.consumerBuffer = buffer;
        this.consumerMask = mask;
        this.maxQueueCapacity = p2capacity;
        this.producerLookAhead = mask - 1L;
        this.soProducerIndex(0L);
    }

    @Override
    public final Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean offer(E e) {
        if (null == e) {
            throw new NullPointerException("Null is not a valid element");
        }
        Object[] buffer = this.producerBuffer;
        long index = this.producerIndex;
        long mask = this.producerMask;
        long offset = CircularArrayOffsetCalculator.calcElementOffset(index, mask);
        if (index < this.producerLookAhead) {
            this.writeToQueue(buffer, e, index, offset);
            return true;
        }
        return this.offerColdPath(e, buffer, index, mask, offset);
    }

    private boolean offerColdPath(E e, E[] buffer, long index, long mask, long offset) {
        int maxCapacity;
        int lookAheadStep = this.producerLookAheadStep;
        if (lookAheadStep > 0) {
            long lookAheadElementOffset = CircularArrayOffsetCalculator.calcElementOffset(index + (long)lookAheadStep, mask);
            if (null == UnsafeRefArrayAccess.lvElement(buffer, lookAheadElementOffset)) {
                this.producerLookAhead = index + (long)lookAheadStep - 1L;
                this.writeToQueue(buffer, e, index, offset);
                return true;
            }
            int maxCapacity2 = this.maxQueueCapacity;
            if (mask + 1L == (long)maxCapacity2) {
                if (null == UnsafeRefArrayAccess.lvElement(buffer, offset)) {
                    this.writeToQueue(buffer, e, index, offset);
                    return true;
                }
                return false;
            }
            if (null == UnsafeRefArrayAccess.lvElement(buffer, CircularArrayOffsetCalculator.calcElementOffset(index + 1L, mask))) {
                this.writeToQueue(buffer, e, index, offset);
            } else {
                int newCapacity = (int)(2L * (mask + 1L));
                E[] newBuffer = CircularArrayOffsetCalculator.allocate(newCapacity + 1);
                this.producerBuffer = newBuffer;
                this.producerMask = newCapacity - 1;
                if (newCapacity == maxCapacity2) {
                    long currConsumerIndex = this.lvConsumerIndex();
                    this.producerLookAheadStep = -((int)(index - currConsumerIndex));
                    this.producerLookAhead = currConsumerIndex + (long)maxCapacity2 - 1L;
                } else {
                    this.producerLookAhead = index + this.producerMask - 1L;
                    this.adjustLookAheadStep(newCapacity);
                }
                long offsetInNew = CircularArrayOffsetCalculator.calcElementOffset(index, this.producerMask);
                this.soProducerIndex(index + 1L);
                UnsafeRefArrayAccess.soElement(newBuffer, offsetInNew, e);
                UnsafeRefArrayAccess.soElement(buffer, this.nextArrayOffset(mask), newBuffer);
                UnsafeRefArrayAccess.soElement(buffer, offset, JUMP);
            }
            return true;
        }
        int prevElementsInOtherBuffers = -lookAheadStep;
        long currConsumerIndex = this.lvConsumerIndex();
        int size = (int)(index - currConsumerIndex);
        if (size == (maxCapacity = (int)mask + 1)) {
            return false;
        }
        long firstIndexInCurrentBuffer = this.producerLookAhead - (long)maxCapacity + (long)prevElementsInOtherBuffers;
        if (currConsumerIndex >= firstIndexInCurrentBuffer) {
            this.adjustLookAheadStep(maxCapacity);
        } else {
            this.producerLookAheadStep = (int)(currConsumerIndex - firstIndexInCurrentBuffer);
        }
        this.producerLookAhead = currConsumerIndex + (long)maxCapacity;
        this.writeToQueue(buffer, e, index, offset);
        return true;
    }

    private void writeToQueue(E[] buffer, E e, long index, long offset) {
        this.soProducerIndex(index + 1L);
        UnsafeRefArrayAccess.soElement(buffer, offset, e);
    }

    @Override
    public final E poll() {
        Object[] buffer = this.consumerBuffer;
        long index = this.consumerIndex;
        long mask = this.consumerMask;
        long offset = CircularArrayOffsetCalculator.calcElementOffset(index, mask);
        Object e = UnsafeRefArrayAccess.lvElement(buffer, offset);
        if (null != e) {
            if (e == JUMP) {
                Object[] nextBuffer = this.getNextBuffer(buffer, mask);
                return (E)this.newBufferPoll(nextBuffer, index);
            }
            this.soConsumerIndex(index + 1L);
            UnsafeRefArrayAccess.soElement(buffer, offset, null);
        }
        return (E)e;
    }

    private E[] getNextBuffer(E[] buffer, long mask) {
        return (Object[])UnsafeRefArrayAccess.lvElement(buffer, this.nextArrayOffset(mask));
    }

    private long nextArrayOffset(long mask) {
        return CircularArrayOffsetCalculator.calcElementOffset(mask + 1L, mask << 2);
    }

    private E newBufferPoll(E[] nextBuffer, long index) {
        long newMask;
        this.consumerBuffer = nextBuffer;
        this.consumerMask = newMask = (long)(nextBuffer.length - 2);
        long offsetInNew = CircularArrayOffsetCalculator.calcElementOffset(index, newMask);
        E n = UnsafeRefArrayAccess.lvElement(nextBuffer, offsetInNew);
        if (null == n) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        this.soConsumerIndex(index + 1L);
        UnsafeRefArrayAccess.soElement(nextBuffer, offsetInNew, null);
        return n;
    }

    @Override
    public final E peek() {
        Object[] buffer = this.consumerBuffer;
        long index = this.consumerIndex;
        long mask = this.consumerMask;
        long offset = CircularArrayOffsetCalculator.calcElementOffset(index, mask);
        Object e = UnsafeRefArrayAccess.lvElement(buffer, offset);
        if (null == e) {
            return null;
        }
        if (e == JUMP) {
            return (E)this.newBufferPeek(this.getNextBuffer(buffer, mask), index);
        }
        return (E)e;
    }

    private E newBufferPeek(E[] nextBuffer, long index) {
        long newMask;
        this.consumerBuffer = nextBuffer;
        this.consumerMask = newMask = (long)(nextBuffer.length - 2);
        long offsetInNew = CircularArrayOffsetCalculator.calcElementOffset(index, newMask);
        return UnsafeRefArrayAccess.lvElement(nextBuffer, offsetInNew);
    }

    @Override
    public final int size() {
        long currentProducerIndex;
        long before;
        long after = this.lvConsumerIndex();
        do {
            before = after;
            currentProducerIndex = this.lvProducerIndex();
        } while (before != (after = this.lvConsumerIndex()));
        return (int)(currentProducerIndex - after);
    }

    private void adjustLookAheadStep(int capacity) {
        this.producerLookAheadStep = Math.min(capacity / 4, SpscArrayQueue.MAX_LOOK_AHEAD_STEP);
    }

    private long lvProducerIndex() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this, P_INDEX_OFFSET);
    }

    private long lvConsumerIndex() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this, C_INDEX_OFFSET);
    }

    private void soProducerIndex(long v) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, P_INDEX_OFFSET, v);
    }

    private void soConsumerIndex(long v) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, C_INDEX_OFFSET, v);
    }

    @Override
    public long currentProducerIndex() {
        return this.lvProducerIndex();
    }

    @Override
    public long currentConsumerIndex() {
        return this.lvConsumerIndex();
    }

    static {
        Field iField;
        try {
            iField = SpscGrowableArrayQueueProducerFields.class.getDeclaredField("producerIndex");
            P_INDEX_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(iField);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        try {
            iField = SpscGrowableArrayQueueConsumerFields.class.getDeclaredField("consumerIndex");
            C_INDEX_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(iField);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        JUMP = new Object();
    }
}

