/*
 * Decompiled with CFR 0.152.
 */
package org.jctools.queues;

import org.jctools.queues.MessagePassingQueue;
import org.jctools.queues.QueueProgressIndicators;
import org.jctools.queues.SpscArrayQueueConsumerField;
import org.jctools.util.Pow2;
import org.jctools.util.UnsafeAccess;
import org.jctools.util.UnsafeRefArrayAccess;

public class SpscArrayQueue<E>
extends SpscArrayQueueConsumerField<E>
implements QueueProgressIndicators {
    long p01;
    long p02;
    long p03;
    long p04;
    long p05;
    long p06;
    long p07;
    long p10;
    long p11;
    long p12;
    long p13;
    long p14;
    long p15;
    long p16;
    long p17;

    public SpscArrayQueue(int capacity) {
        super(Math.max(Pow2.roundToPowerOfTwo(capacity), 4));
    }

    @Override
    public boolean offer(E e) {
        if (null == e) {
            throw new NullPointerException("Null is not a valid element");
        }
        Object[] buffer = this.buffer;
        long mask = this.mask;
        long producerIndex = this.producerIndex;
        long offset = SpscArrayQueue.calcElementOffset(producerIndex, mask);
        if (producerIndex >= this.producerLookAhead) {
            int lookAheadStep = this.lookAheadStep;
            if (null == UnsafeRefArrayAccess.lvElement(buffer, SpscArrayQueue.calcElementOffset(producerIndex + (long)lookAheadStep, mask))) {
                this.producerLookAhead = producerIndex + (long)lookAheadStep;
            } else if (null != UnsafeRefArrayAccess.lvElement(buffer, offset)) {
                return false;
            }
        }
        UnsafeRefArrayAccess.soElement(buffer, offset, e);
        this.soProducerIndex(producerIndex + 1L);
        return true;
    }

    @Override
    public E poll() {
        Object[] buffer = this.buffer;
        long consumerIndex = this.consumerIndex;
        long offset = this.calcElementOffset(consumerIndex);
        Object e = UnsafeRefArrayAccess.lvElement(buffer, offset);
        if (null == e) {
            return null;
        }
        UnsafeRefArrayAccess.soElement(buffer, offset, null);
        this.soConsumerIndex(consumerIndex + 1L);
        return (E)e;
    }

    @Override
    public E peek() {
        return (E)UnsafeRefArrayAccess.lvElement(this.buffer, this.calcElementOffset(this.consumerIndex));
    }

    @Override
    public int size() {
        long currentProducerIndex;
        long before;
        long after = this.lvConsumerIndex();
        do {
            before = after;
            currentProducerIndex = this.lvProducerIndex();
        } while (before != (after = this.lvConsumerIndex()));
        return (int)(currentProducerIndex - after);
    }

    private void soProducerIndex(long v) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, P_INDEX_OFFSET, v);
    }

    private void soConsumerIndex(long v) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, C_INDEX_OFFSET, v);
    }

    private long lvProducerIndex() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this, P_INDEX_OFFSET);
    }

    private long lvConsumerIndex() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this, C_INDEX_OFFSET);
    }

    @Override
    public long currentProducerIndex() {
        return this.lvProducerIndex();
    }

    @Override
    public long currentConsumerIndex() {
        return this.lvConsumerIndex();
    }

    @Override
    public boolean relaxedOffer(E message) {
        return this.offer(message);
    }

    @Override
    public E relaxedPoll() {
        return this.poll();
    }

    @Override
    public E relaxedPeek() {
        return this.peek();
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c) {
        return this.drain(c, this.capacity());
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s) {
        return this.fill(s, this.capacity());
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c, int limit) {
        Object[] buffer = this.buffer;
        long mask = this.mask;
        long consumerIndex = this.consumerIndex;
        for (int i = 0; i < limit; ++i) {
            long index = consumerIndex + (long)i;
            long offset = SpscArrayQueue.calcElementOffset(index, mask);
            Object e = UnsafeRefArrayAccess.lvElement(buffer, offset);
            if (null == e) {
                return i;
            }
            UnsafeRefArrayAccess.soElement(buffer, offset, null);
            this.soConsumerIndex(index + 1L);
            c.accept(e);
        }
        return limit;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s, int limit) {
        Object[] buffer = this.buffer;
        long mask = this.mask;
        int lookAheadStep = this.lookAheadStep;
        long producerIndex = this.producerIndex;
        for (int i = 0; i < limit; ++i) {
            long index = producerIndex + (long)i;
            long lookAheadElementOffset = SpscArrayQueue.calcElementOffset(index + (long)lookAheadStep, mask);
            if (null == UnsafeRefArrayAccess.lvElement(buffer, lookAheadElementOffset)) {
                int lookAheadLimit = Math.min(lookAheadStep, limit - i);
                for (int j = 0; j < lookAheadLimit; ++j) {
                    long offset = SpscArrayQueue.calcElementOffset(index + (long)j, mask);
                    UnsafeRefArrayAccess.soElement(buffer, offset, s.get());
                    this.soProducerIndex(index + (long)j + 1L);
                }
                i += lookAheadLimit - 1;
                continue;
            }
            long offset = SpscArrayQueue.calcElementOffset(index, mask);
            if (null != UnsafeRefArrayAccess.lvElement(buffer, offset)) {
                return i;
            }
            UnsafeRefArrayAccess.soElement(buffer, offset, s.get());
            this.soProducerIndex(index + 1L);
        }
        return limit;
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> c, MessagePassingQueue.WaitStrategy w, MessagePassingQueue.ExitCondition exit) {
        Object[] buffer = this.buffer;
        long mask = this.mask;
        long consumerIndex = this.consumerIndex;
        int counter = 0;
        while (exit.keepRunning()) {
            for (int i = 0; i < 4096; ++i) {
                long offset = SpscArrayQueue.calcElementOffset(consumerIndex, mask);
                Object e = UnsafeRefArrayAccess.lvElement(buffer, offset);
                if (null == e) {
                    counter = w.idle(counter);
                    continue;
                }
                counter = 0;
                UnsafeRefArrayAccess.soElement(buffer, offset, null);
                this.soConsumerIndex(++consumerIndex);
                c.accept(e);
            }
        }
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> s, MessagePassingQueue.WaitStrategy w, MessagePassingQueue.ExitCondition e) {
        Object[] buffer = this.buffer;
        long mask = this.mask;
        int lookAheadStep = this.lookAheadStep;
        long producerIndex = this.producerIndex;
        int counter = 0;
        while (e.keepRunning()) {
            long lookAheadElementOffset = SpscArrayQueue.calcElementOffset(producerIndex + (long)lookAheadStep, mask);
            if (null == UnsafeRefArrayAccess.lvElement(buffer, lookAheadElementOffset)) {
                for (int j = 0; j < lookAheadStep; ++j) {
                    long offset = SpscArrayQueue.calcElementOffset(producerIndex, mask);
                    UnsafeRefArrayAccess.soElement(buffer, offset, s.get());
                    this.soProducerIndex(++producerIndex);
                }
                continue;
            }
            long offset = SpscArrayQueue.calcElementOffset(producerIndex, mask);
            if (null != UnsafeRefArrayAccess.lvElement(buffer, offset)) {
                counter = w.idle(counter);
                continue;
            }
            counter = 0;
            UnsafeRefArrayAccess.soElement(buffer, offset, s.get());
            this.soProducerIndex(++producerIndex);
        }
    }
}

