/*
 * Decompiled with CFR 0.152.
 */
package org.jctools.queues;

import org.jctools.queues.BaseLinkedQueue;
import org.jctools.queues.LinkedQueueNode;
import org.jctools.queues.MessagePassingQueue;

abstract class MpscLinkedQueue<E>
extends BaseLinkedQueue<E> {
    protected MpscLinkedQueue() {
        this.consumerNode = new LinkedQueueNode();
        this.xchgProducerNode(this.consumerNode);
    }

    protected abstract LinkedQueueNode<E> xchgProducerNode(LinkedQueueNode<E> var1);

    @Override
    public final boolean offer(E nextValue) {
        if (nextValue == null) {
            throw new IllegalArgumentException("null elements not allowed");
        }
        LinkedQueueNode<E> nextNode = new LinkedQueueNode<E>(nextValue);
        LinkedQueueNode<E> prevProducerNode = this.xchgProducerNode(nextNode);
        prevProducerNode.soNext(nextNode);
        return true;
    }

    @Override
    public final E poll() {
        LinkedQueueNode currConsumerNode = this.lpConsumerNode();
        LinkedQueueNode nextNode = currConsumerNode.lvNext();
        if (nextNode != null) {
            Object nextValue = nextNode.getAndNullValue();
            this.spConsumerNode(nextNode);
            return nextValue;
        }
        if (currConsumerNode != this.lvProducerNode()) {
            while ((nextNode = currConsumerNode.lvNext()) == null) {
            }
            Object nextValue = nextNode.getAndNullValue();
            this.consumerNode = nextNode;
            return nextValue;
        }
        return null;
    }

    @Override
    public final E peek() {
        LinkedQueueNode currConsumerNode = this.consumerNode;
        LinkedQueueNode nextNode = currConsumerNode.lvNext();
        if (nextNode != null) {
            return nextNode.lpValue();
        }
        if (currConsumerNode != this.lvProducerNode()) {
            while ((nextNode = currConsumerNode.lvNext()) == null) {
            }
            return nextNode.lpValue();
        }
        return null;
    }

    @Override
    public boolean relaxedOffer(E message) {
        return this.offer(message);
    }

    @Override
    public E relaxedPoll() {
        LinkedQueueNode currConsumerNode = this.lpConsumerNode();
        LinkedQueueNode nextNode = currConsumerNode.lvNext();
        if (nextNode != null) {
            Object nextValue = nextNode.getAndNullValue();
            this.spConsumerNode(nextNode);
            return nextValue;
        }
        return null;
    }

    @Override
    public E relaxedPeek() {
        LinkedQueueNode currConsumerNode = this.consumerNode;
        LinkedQueueNode nextNode = currConsumerNode.lvNext();
        if (nextNode != null) {
            return nextNode.lpValue();
        }
        if (currConsumerNode != this.lvProducerNode()) {
            while ((nextNode = currConsumerNode.lvNext()) == null) {
            }
            return nextNode.lpValue();
        }
        return null;
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c) {
        int drained;
        long result = 0L;
        while ((drained = this.drain(c, 4096)) == 4096 && (result += (long)drained) <= 0x7FFFEFFFL) {
        }
        return (int)result;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s) {
        long result = 0L;
        do {
            this.fill(s, 4096);
        } while ((result += 4096L) <= 0x7FFFEFFFL);
        return (int)result;
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c, int limit) {
        LinkedQueueNode chaserNode = this.consumerNode;
        for (int i = 0; i < limit; ++i) {
            if ((chaserNode = chaserNode.lvNext()) == null) {
                return i;
            }
            Object nextValue = chaserNode.getAndNullValue();
            this.consumerNode = chaserNode;
            c.accept(nextValue);
        }
        return limit;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s, int limit) {
        LinkedQueueNode chaserNode = this.producerNode;
        for (int i = 0; i < limit; ++i) {
            this.offer(s.get());
        }
        return limit;
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> c, MessagePassingQueue.WaitStrategy wait, MessagePassingQueue.ExitCondition exit) {
        LinkedQueueNode chaserNode = this.consumerNode;
        int idleCounter = 0;
        while (exit.keepRunning()) {
            for (int i = 0; i < 4096; ++i) {
                LinkedQueueNode next = chaserNode.lvNext();
                if (next == null) {
                    idleCounter = wait.idle(idleCounter);
                    continue;
                }
                chaserNode = next;
                idleCounter = 0;
                Object nextValue = chaserNode.getAndNullValue();
                this.consumerNode = chaserNode;
                c.accept(nextValue);
            }
        }
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> s, MessagePassingQueue.WaitStrategy wait, MessagePassingQueue.ExitCondition exit) {
        while (exit.keepRunning()) {
            this.fill(s, 4096);
        }
    }
}

