/*
 * Decompiled with CFR 0.152.
 */
package org.jctools.queues;

import java.util.Iterator;
import org.jctools.queues.MpscArrayQueue;
import org.jctools.queues.MpscCompoundQueueConsumerQueueIndex;

public final class MpscCompoundQueue<E>
extends MpscCompoundQueueConsumerQueueIndex<E> {
    private static final int CPUS = Runtime.getRuntime().availableProcessors();
    long p00;
    long p01;
    long p02;
    long p03;
    long p04;
    long p05;
    long p06;
    long p30;
    long p31;
    long p32;
    long p33;
    long p34;
    long p35;
    long p36;
    long p37;

    public MpscCompoundQueue(int capacity) {
        this(capacity, CPUS);
    }

    public MpscCompoundQueue(int capacity, int queueParallelism) {
        super(capacity, queueParallelism);
    }

    @Override
    public boolean offer(E e) {
        int status;
        int start = (int)(Thread.currentThread().getId() & (long)this.parallelQueuesMask);
        if (this.queues[start].offer(e)) {
            return true;
        }
        do {
            status = 0;
            for (int i = start; i < start + this.parallelQueues; ++i) {
                int s = this.queues[i & this.parallelQueuesMask].weakOffer(e);
                if (s == 0) {
                    return true;
                }
                status += s;
            }
        } while (status != this.parallelQueues);
        return false;
    }

    @Override
    public E poll() {
        int qIndex;
        int limit = qIndex + this.parallelQueues;
        E e = null;
        for (qIndex = this.consumerQueueIndex & this.parallelQueuesMask; qIndex < limit && (e = (E)this.queues[qIndex & this.parallelQueuesMask].poll()) == null; ++qIndex) {
        }
        this.consumerQueueIndex = qIndex;
        return e;
    }

    @Override
    public E peek() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        int size = 0;
        for (MpscArrayQueue lane : this.queues) {
            size += lane.size();
        }
        return size;
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }
}

