/*
 * Decompiled with CFR 0.152.
 */
package com.notification.types;

import com.notification.Notification;
import com.theme.WindowTheme;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JWindow;

public abstract class WindowNotification
extends Notification {
    private JWindow m_window = new JWindow();
    private JPanel m_panel;
    private boolean m_closeOnClick;
    private MouseAdapter m_listener;
    private WindowTheme m_theme;
    private static final int DEFAULT_WIDTH = 300;
    private static final int DEFAULT_HEIGHT = 100;
    public static final String CLICKED = "clicked";
    public static final String SHOWN = "shown";
    public static final String HIDDEN = "hidden";

    public WindowNotification() {
        this.m_window.setAlwaysOnTop(true);
        this.m_listener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                WindowNotification.this.fireListeners(WindowNotification.CLICKED);
                if (WindowNotification.this.m_closeOnClick) {
                    WindowNotification.this.removeFromManager();
                }
            }
        };
        this.setSize(300, 100);
        this.setPanel(new JPanel());
    }

    protected JWindow getWindow() {
        return this.m_window;
    }

    protected void setPanel(JPanel panel) {
        if (this.m_panel != null) {
            this.m_window.remove(this.m_panel);
            this.m_panel.removeMouseListener(this.m_listener);
        }
        this.m_panel = panel;
        this.m_window.add(this.m_panel);
        this.m_panel.addMouseListener(this.m_listener);
    }

    public boolean isCloseOnClick() {
        return this.m_closeOnClick;
    }

    public void setCloseOnClick(boolean close) {
        this.m_closeOnClick = close;
    }

    protected WindowTheme getWindowTheme() {
        return this.m_theme;
    }

    public void setWindowTheme(WindowTheme theme) {
        this.m_theme = theme;
        this.m_window.setBackground(theme.background);
        this.m_window.setForeground(theme.foreground);
        this.m_window.setOpacity((float)theme.opacity);
        this.m_window.setSize(theme.width, theme.height);
        this.m_panel.setBackground(theme.background);
        this.m_panel.setForeground(theme.foreground);
        for (Component comp : this.m_panel.getComponents()) {
            this.recursiveSetTheme(theme, comp);
        }
    }

    private void recursiveSetTheme(WindowTheme theme, Component comp) {
        comp.setBackground(theme.background);
        comp.setForeground(theme.foreground);
        if (comp instanceof Container) {
            Container container = (Container)comp;
            for (Component component : container.getComponents()) {
                this.recursiveSetTheme(theme, component);
            }
        }
    }

    @Override
    public int getX() {
        return this.m_window.getX();
    }

    @Override
    public int getY() {
        return this.m_window.getY();
    }

    @Override
    public void setLocation(int x, int y) {
        this.m_window.setLocation(x, y);
    }

    @Override
    public int getWidth() {
        return this.m_window.getWidth();
    }

    @Override
    public int getHeight() {
        return this.m_window.getHeight();
    }

    @Override
    public void setSize(int width, int height) {
        this.m_window.setSize(width, height);
    }

    @Override
    public double getOpacity() {
        return this.m_window.getOpacity();
    }

    @Override
    public void setOpacity(double opacity) {
        if (opacity < 0.0) {
            opacity = 0.0;
        }
        if (opacity > 1.0) {
            opacity = 1.0;
        }
        this.m_window.setOpacity((float)opacity);
    }

    @Override
    public void show() {
        this.m_window.setVisible(true);
        this.fireListeners(SHOWN);
    }

    @Override
    public void hide() {
        this.m_window.setVisible(false);
        this.fireListeners(HIDDEN);
    }

    @Override
    public boolean isShown() {
        return this.m_window.isVisible();
    }
}

