/*
 * Decompiled with CFR 0.152.
 */
package com.notification.types;

import com.notification.types.BorderLayoutNotification;
import com.theme.TextTheme;
import com.theme.WindowTheme;
import javax.swing.JLabel;

public class TextNotification
extends BorderLayoutNotification {
    protected JLabel m_titleLabel = new JLabel();
    protected JLabel m_subtitleLabel = new JLabel();
    private TextTheme m_textTheme;

    public TextNotification() {
        this.addComponent(this.m_titleLabel, "North");
        this.addComponent(this.m_subtitleLabel, "Center");
    }

    public String getTitle() {
        return this.m_titleLabel.getText();
    }

    public void setTitle(String title) {
        this.m_titleLabel.setText(title);
    }

    public String getSubtitle() {
        return this.m_subtitleLabel.getText();
    }

    public void setSubtitle(String subtitle) {
        this.m_subtitleLabel.setText(subtitle);
    }

    protected TextTheme getTextTheme() {
        return this.m_textTheme;
    }

    public void setTextTheme(TextTheme theme) {
        this.m_textTheme = theme;
        this.m_titleLabel.setFont(theme.title);
        this.m_subtitleLabel.setFont(theme.subtitle);
        this.m_titleLabel.setForeground(theme.titleColor);
        this.m_subtitleLabel.setForeground(theme.subtitleColor);
    }

    @Override
    public void setWindowTheme(WindowTheme theme) {
        super.setWindowTheme(theme);
        if (this.m_textTheme != null) {
            this.m_titleLabel.setForeground(this.m_textTheme.titleColor);
            this.m_subtitleLabel.setForeground(this.m_textTheme.subtitleColor);
        }
    }
}

