/*
 * Decompiled with CFR 0.152.
 */
package com.notification.types;

import com.notification.types.TextNotification;
import com.theme.TextTheme;
import com.theme.WindowTheme;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;

public class AcceptNotification
extends TextNotification {
    private JButton m_accept = new JButton("Accept");
    private JButton m_decline = new JButton("Decline");
    private boolean m_accepted;

    public AcceptNotification() {
        this.m_accept.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                AcceptNotification.this.removeFromManager();
                AcceptNotification.this.m_accepted = true;
                AcceptNotification acceptNotification = AcceptNotification.this;
                synchronized (acceptNotification) {
                    AcceptNotification.this.notifyAll();
                }
            }
        });
        this.m_decline.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                AcceptNotification.this.removeFromManager();
                AcceptNotification.this.m_accepted = false;
                AcceptNotification acceptNotification = AcceptNotification.this;
                synchronized (acceptNotification) {
                    AcceptNotification.this.notifyAll();
                }
            }
        });
        this.setButtonDimensions(new Dimension(100, 22));
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.m_decline);
        buttonPanel.add(this.m_accept);
        this.addComponent(buttonPanel, "South");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean blockUntilReply() {
        AcceptNotification acceptNotification = this;
        synchronized (acceptNotification) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.m_accepted;
    }

    public void setButtonDimensions(Dimension d) {
        this.m_accept.setPreferredSize(d);
        this.m_decline.setPreferredSize(d);
    }

    public String getAcceptText() {
        return this.m_accept.getText();
    }

    public void setAcceptText(String acceptText) {
        this.m_accept.setText(acceptText);
    }

    public String getDeclineText() {
        return this.m_decline.getText();
    }

    public void setDeclineText(String declineText) {
        this.m_decline.setText(declineText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hide() {
        super.hide();
        this.m_accepted = false;
        AcceptNotification acceptNotification = this;
        synchronized (acceptNotification) {
            this.notifyAll();
        }
    }

    @Override
    public void setTextTheme(TextTheme theme) {
        super.setTextTheme(theme);
        this.m_accept.setForeground(theme.subtitleColor);
        this.m_decline.setForeground(theme.subtitleColor);
    }

    @Override
    public void setWindowTheme(WindowTheme theme) {
        super.setWindowTheme(theme);
        if (this.getTextTheme() != null) {
            this.m_accept.setForeground(this.getTextTheme().subtitleColor);
            this.m_decline.setForeground(this.getTextTheme().subtitleColor);
        }
    }
}

