/*
 * Decompiled with CFR 0.152.
 */
package com.notification.manager;

import com.notification.Notification;
import com.notification.NotificationFactory;
import com.notification.NotificationManager;
import com.utils.Screen;
import com.utils.Time;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.Timer;

public class SlideManager
extends NotificationManager {
    private NotificationFactory.Location m_loc;
    private Screen m_standardScreen;
    private Screen m_noPaddingScreen;
    private HashMap<SlideDirection, Slider> m_sliders = new HashMap();
    private SlideDirection m_slideIn;
    private SlideDirection m_slideOut;
    private double m_slideSpeed;
    private HashMap<Notification, SlideDirection> m_slideOutDirections;
    private boolean m_overwrite;

    public SlideManager() {
        this.m_sliders.put(SlideDirection.NORTH, new NorthSlider());
        this.m_sliders.put(SlideDirection.SOUTH, new SouthSlider());
        this.m_sliders.put(SlideDirection.EAST, new EastSlider());
        this.m_sliders.put(SlideDirection.WEST, new WestSlider());
        this.m_standardScreen = Screen.standard();
        this.m_noPaddingScreen = Screen.withPadding(0);
        this.m_slideSpeed = 300.0;
        this.m_slideOutDirections = new HashMap();
        this.m_overwrite = false;
        this.m_loc = NotificationFactory.Location.NORTHEAST;
        this.recalculateSlideDirection();
    }

    public SlideManager(NotificationFactory.Location loc) {
        this.m_sliders.put(SlideDirection.NORTH, new NorthSlider());
        this.m_sliders.put(SlideDirection.SOUTH, new SouthSlider());
        this.m_sliders.put(SlideDirection.EAST, new EastSlider());
        this.m_sliders.put(SlideDirection.WEST, new WestSlider());
        this.m_standardScreen = Screen.standard();
        this.m_noPaddingScreen = Screen.withPadding(0);
        this.m_slideSpeed = 300.0;
        this.m_slideOutDirections = new HashMap();
        this.m_overwrite = false;
        this.m_loc = loc;
        this.recalculateSlideDirection();
    }

    public NotificationFactory.Location getLocation() {
        return this.m_loc;
    }

    public void setLocation(NotificationFactory.Location loc) {
        this.m_loc = loc;
        if (!this.m_overwrite) {
            this.recalculateSlideDirection();
        }
    }

    public SlideDirection getSlideDirection() {
        return this.m_slideIn;
    }

    public void setSlideDirection(SlideDirection slide) {
        this.m_slideIn = slide;
        this.m_slideOut = slide.getOpposite();
        this.m_overwrite = true;
    }

    public double getSlideSpeed() {
        return this.m_slideSpeed;
    }

    public void setSlideSpeed(double slideSpeed) {
        this.m_slideSpeed = slideSpeed;
    }

    protected Screen getScreen() {
        return this.m_standardScreen;
    }

    private void recalculateSlideDirection() {
        switch (this.m_loc) {
            case NORTHWEST: 
            case NORTH: 
            case NORTHEAST: {
                this.m_slideIn = SlideDirection.SOUTH;
                break;
            }
            case EAST: {
                this.m_slideIn = SlideDirection.WEST;
                break;
            }
            case SOUTHEAST: 
            case SOUTH: 
            case SOUTHWEST: {
                this.m_slideIn = SlideDirection.NORTH;
                break;
            }
            case WEST: {
                this.m_slideIn = SlideDirection.EAST;
            }
        }
        this.m_slideOut = this.m_slideIn.getOpposite();
    }

    @Override
    protected void notificationAdded(Notification note, Time time) {
        double delay = 50.0;
        double slideDelta = this.m_slideSpeed / delay;
        this.m_sliders.get((Object)this.m_slideIn).setBorderPosition(note);
        this.m_sliders.get((Object)this.m_slideIn).animate(note, delay, slideDelta, true);
        note.show();
        double slideTime = (double)this.m_standardScreen.getPadding() / this.m_slideSpeed;
        this.scheduleRemoval(note, time.add(Time.seconds(slideTime)));
        this.m_slideOutDirections.put(note, this.m_slideOut);
    }

    @Override
    protected void notificationRemoved(Notification note) {
        double delay = 50.0;
        double slideDelta = this.m_slideSpeed / delay;
        this.m_sliders.get((Object)this.m_slideOutDirections.get(note)).animate(note, delay, slideDelta, false);
        this.m_slideOutDirections.remove(note);
    }

    private class WestSlider
    extends Slider {
        private WestSlider() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.m_x -= this.m_delta;
            if (this.m_x <= this.m_stopX) {
                this.m_x = this.m_stopX;
                this.manageStop(e);
            }
            this.m_note.setLocation((int)this.m_x, (int)this.m_y);
        }

        @Override
        public void setBorderPosition(Notification note) {
            note.setLocation(SlideManager.this.m_noPaddingScreen.getX(SlideManager.this.m_loc, note), SlideManager.this.m_standardScreen.getY(SlideManager.this.m_loc, note));
        }
    }

    private class EastSlider
    extends Slider {
        private EastSlider() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.m_x += this.m_delta;
            if (this.m_x >= this.m_stopX) {
                this.m_x = this.m_stopX;
                this.manageStop(e);
            }
            this.m_note.setLocation((int)this.m_x, (int)this.m_y);
        }

        @Override
        public void setBorderPosition(Notification note) {
            note.setLocation(SlideManager.this.m_noPaddingScreen.getX(SlideManager.this.m_loc, note), SlideManager.this.m_standardScreen.getY(SlideManager.this.m_loc, note));
        }
    }

    private class SouthSlider
    extends Slider {
        private SouthSlider() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.m_y += this.m_delta;
            if (this.m_y >= this.m_stopY) {
                this.m_y = this.m_stopY;
                this.manageStop(e);
            }
            this.m_note.setLocation((int)this.m_x, (int)this.m_y);
        }

        @Override
        public void setBorderPosition(Notification note) {
            note.setLocation(SlideManager.this.m_standardScreen.getX(SlideManager.this.m_loc, note), SlideManager.this.m_noPaddingScreen.getY(SlideManager.this.m_loc, note));
        }
    }

    private class NorthSlider
    extends Slider {
        private NorthSlider() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.m_y -= this.m_delta;
            if (this.m_y <= this.m_stopY) {
                this.m_y = this.m_stopY;
                this.manageStop(e);
            }
            this.m_note.setLocation((int)this.m_x, (int)this.m_y);
        }

        @Override
        public void setBorderPosition(Notification note) {
            note.setLocation(SlideManager.this.m_standardScreen.getX(SlideManager.this.m_loc, note), SlideManager.this.m_noPaddingScreen.getY(SlideManager.this.m_loc, note));
        }
    }

    private abstract class Slider
    implements ActionListener {
        protected Notification m_note;
        protected double m_delta;
        protected double m_stopX;
        protected double m_stopY;
        protected double m_x;
        protected double m_y;
        protected boolean m_slideIn;

        private Slider() {
        }

        public void animate(Notification note, double delay, double slideDelta, boolean slideIn) {
            this.m_note = note;
            this.m_x = note.getX();
            this.m_y = note.getY();
            this.m_delta = Math.abs(slideDelta);
            this.m_slideIn = slideIn;
            if (this.m_slideIn) {
                this.m_stopX = SlideManager.this.m_standardScreen.getX(SlideManager.this.m_loc, note);
                this.m_stopY = SlideManager.this.m_standardScreen.getY(SlideManager.this.m_loc, note);
            } else {
                this.m_stopX = SlideManager.this.m_noPaddingScreen.getX(SlideManager.this.m_loc, note);
                this.m_stopY = SlideManager.this.m_noPaddingScreen.getY(SlideManager.this.m_loc, note);
            }
            Timer timer = new Timer((int)delay, this);
            timer.start();
        }

        protected void manageStop(ActionEvent e) {
            ((Timer)e.getSource()).stop();
            if (!this.m_slideIn) {
                this.m_note.hide();
            }
        }

        public abstract void setBorderPosition(Notification var1);
    }

    public static enum SlideDirection {
        NORTH,
        SOUTH(NORTH),
        EAST,
        WEST(EAST);

        private SlideDirection m_opposite;

        private SlideDirection() {
        }

        private SlideDirection(SlideDirection opposite) {
            this.m_opposite = opposite;
            opposite.m_opposite = this;
        }

        public SlideDirection getOpposite() {
            return this.m_opposite;
        }
    }
}

