/*
 * Decompiled with CFR 0.152.
 */
package com.notification.manager;

import com.notification.Notification;
import com.notification.NotificationFactory;
import com.notification.NotificationManager;
import com.platform.Platform;
import com.utils.Screen;
import com.utils.Time;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class SimpleManager
extends NotificationManager {
    private NotificationFactory.Location m_loc;
    private Screen m_screen = Screen.standard();
    private boolean m_fadeEnabled = false;
    private Time m_fadeTime = Time.seconds(1.0);
    private static final int FADE_DELAY = 100;

    public SimpleManager() {
        this.m_loc = NotificationFactory.Location.NORTHEAST;
    }

    public SimpleManager(NotificationFactory.Location loc) {
        this.m_loc = loc;
    }

    public Time getFadeTime() {
        return this.m_fadeTime;
    }

    public void setFadeTime(Time fadeTime) {
        this.m_fadeTime = fadeTime;
    }

    public boolean isFadeEnabled() {
        this.syncFadeEnabledWithPlatform();
        return this.m_fadeEnabled;
    }

    public void setFadeEnabled(boolean fadeEnabled) {
        this.m_fadeEnabled = fadeEnabled;
        this.syncFadeEnabledWithPlatform();
    }

    private void syncFadeEnabledWithPlatform() {
        if (this.m_fadeEnabled && Platform.instance().isUsed()) {
            this.m_fadeEnabled = Platform.instance().isSupported("fade");
        }
    }

    public NotificationFactory.Location getLocation() {
        return this.m_loc;
    }

    public void setLocation(NotificationFactory.Location loc) {
        this.m_loc = loc;
    }

    protected Screen getScreen() {
        return this.m_screen;
    }

    @Override
    protected void notificationAdded(Notification note, Time time) {
        note.setLocation(this.m_screen.getX(this.m_loc, note), this.m_screen.getY(this.m_loc, note));
        if (this.isFadeEnabled()) {
            double opacity = note.getOpacity();
            note.setOpacity(0.0);
            this.startFade(note, opacity);
            this.scheduleRemoval(note, time.add(this.m_fadeTime));
        } else {
            this.scheduleRemoval(note, time);
        }
        note.show();
    }

    @Override
    protected void notificationRemoved(Notification note) {
        if (this.isFadeEnabled()) {
            this.startFade(note, -note.getOpacity());
        } else {
            note.hide();
        }
    }

    private void startFade(Notification note, double deltaOpacity) {
        Timer timer = new Timer(100, new Fader(note, this.getDeltaFade(deltaOpacity), deltaOpacity));
        timer.start();
    }

    private double getDeltaFade(double deltaOpacity) {
        double numTimes = (double)this.m_fadeTime.getMilliseconds() / 100.0;
        double fade = deltaOpacity / numTimes;
        return fade;
    }

    private class Fader
    implements ActionListener {
        private Notification m_note;
        private double m_deltaFade;
        private double m_stopFade;

        public Fader(Notification note, double deltaFade, double stopFade) {
            this.m_note = note;
            this.m_deltaFade = deltaFade;
            this.m_stopFade = stopFade;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.m_deltaFade > 0.0 ? this.m_note.getOpacity() < this.m_stopFade : this.m_note.getOpacity() > this.m_stopFade) {
                this.m_note.setOpacity(this.m_note.getOpacity() + this.m_deltaFade);
            } else {
                ((Timer)e.getSource()).stop();
                if (this.m_deltaFade < 0.0) {
                    this.m_note.hide();
                }
            }
        }
    }
}

