/*
 * Decompiled with CFR 0.152.
 */
package com.notification.manager;

import com.notification.Notification;
import com.notification.NotificationFactory;
import com.notification.manager.SimpleManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Timer;

public class QueueManager
extends SimpleManager {
    private Timer m_timer;
    private int m_verticalPadding = 20;
    private ScrollDirection m_scroll = ScrollDirection.SOUTH;

    public QueueManager() {
        this.m_timer = new Timer(50, new MovementManager());
        this.m_timer.start();
    }

    public QueueManager(NotificationFactory.Location loc) {
        super(loc);
        this.m_timer = new Timer(50, new MovementManager());
        this.m_timer.start();
    }

    public int getVerticalPadding() {
        return this.m_verticalPadding;
    }

    public void setVerticalPadding(int verticalPadding) {
        this.m_verticalPadding = verticalPadding;
    }

    public ScrollDirection getScrollDirection() {
        return this.m_scroll;
    }

    public void setScrollDirection(ScrollDirection dir) {
        this.m_scroll = dir;
    }

    public void stop() {
        this.m_timer.stop();
    }

    private class MovementManager
    implements ActionListener {
        private MovementManager() {
        }

        private int getPreviousShownIndex(List<Notification> notes, int startIndex) {
            for (int i = startIndex; i < notes.size(); ++i) {
                if (!notes.get(i).isShown()) continue;
                return i;
            }
            return -1;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<Notification> notes = QueueManager.this.getNotifications();
            if (notes.size() == 0) {
                return;
            }
            NotificationFactory.Location loc = QueueManager.this.getLocation();
            int x = QueueManager.this.getScreen().getX(loc, notes.get(0));
            int y = QueueManager.this.getScreen().getY(loc, notes.get(0));
            for (int i = notes.size() - 1; i >= 0; --i) {
                Notification note = notes.get(i);
                int prevIndex = this.getPreviousShownIndex(notes, i + 1);
                int dif = 0;
                int desdif = 0;
                if (prevIndex == -1) {
                    dif = note.getY() - y;
                    desdif = 0;
                } else {
                    Notification prev = notes.get(prevIndex);
                    dif = note.getY() - prev.getY();
                    desdif = QueueManager.this.m_scroll == ScrollDirection.SOUTH ? prev.getHeight() + QueueManager.this.m_verticalPadding : -prev.getHeight() - QueueManager.this.m_verticalPadding;
                }
                int delta = desdif - dif;
                int setNum = delta / 3;
                if (delta == 0) continue;
                if (Math.abs(delta) < 3) {
                    setNum = delta > 0 ? 1 : -1;
                }
                note.setLocation(x, note.getY() + setNum);
            }
        }
    }

    public static enum ScrollDirection {
        NORTH,
        SOUTH;

    }
}

