/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.privatechef;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import org.jclouds.ContextBuilder;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.chef.ChefContext;
import org.jclouds.chef.filters.SignedHeaderAuthTest;
import org.jclouds.logging.config.NullLoggingModule;
import org.jclouds.privatechef.PrivateChefApi;
import org.jclouds.privatechef.PrivateChefApiMetadata;
import org.jclouds.rest.internal.BaseRestApiTest;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="PrivateChefApiContextTest")
public class PrivateChefApiContextTest {
    private ChefContext context;

    @BeforeClass
    public void setup() {
        this.context = (ChefContext)ContextBuilder.newBuilder((ApiMetadata)new PrivateChefApiMetadata()).credentials("spec-user", SignedHeaderAuthTest.PRIVATE_KEY).modules((Iterable)ImmutableSet.of((Object)new BaseRestApiTest.MockModule(), (Object)new NullLoggingModule())).buildView(ChefContext.class);
    }

    public void testCanAccessPrivateChefApi() {
        PrivateChefApi api = (PrivateChefApi)this.context.getApi(PrivateChefApi.class);
        Assert.assertNotNull((Object)api);
    }

    @AfterClass
    public void tearDown() {
        try {
            this.context.close();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

